/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.listeners;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.PlayerData;
import com.candyrush.models.TeamColor;
import com.candyrush.utils.MessageUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class PvpListener
implements Listener {
    private final CandyRushPlugin plugin;
    private final Map<UUID, UUID> lastVictims;

    public PvpListener(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.lastVictims = new HashMap<UUID, UUID>();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=false)
    public void onPlayerDamage(EntityDamageByEntityEvent event) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        if (!(event.getDamager() instanceof Player)) {
            return;
        }
        Player victim = (Player)event.getEntity();
        Player attacker = (Player)event.getDamager();
        if (attacker.equals((Object)victim)) {
            return;
        }
        PlayerData attackerData = this.plugin.getPlayerManager().getOrCreatePlayerData(attacker);
        PlayerData victimData = this.plugin.getPlayerManager().getOrCreatePlayerData(victim);
        boolean attackerIsMurderer = attackerData.isMurdererActive();
        boolean victimIsMurderer = victimData.isMurdererActive();
        if (!attackerIsMurderer && !victimIsMurderer) {
            TeamColor attackerTeam = attackerData.getTeamColor();
            TeamColor victimTeam = victimData.getTeamColor();
            if (attackerTeam != null && victimTeam != null && attackerTeam == victimTeam) {
                event.setCancelled(true);
                return;
            }
        }
        if (victimIsMurderer) {
            return;
        }
        this.applyMurdererPenalty(attacker, victim, attackerData);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerDeath(PlayerDeathEvent event) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        Player victim = event.getEntity();
        Player killer = victim.getKiller();
        boolean victimIsMurderer = this.plugin.getPlayerManager().isMurderer(victim.getUniqueId());
        if (!victimIsMurderer) {
            event.setKeepInventory(true);
            event.setKeepLevel(true);
            event.getDrops().clear();
            event.setDroppedExp(0);
        } else {
            this.plugin.getLogger().info("Murderer " + victim.getName() + " died - items will drop");
        }
        if (killer == null) {
            this.handleNonPvpDeath(victim);
            return;
        }
        if (killer.equals((Object)victim)) {
            this.handleNonPvpDeath(victim);
            return;
        }
        this.handlePvpDeath(killer, victim);
    }

    private void handleNonPvpDeath(Player victim) {
        PlayerData victimData = this.plugin.getPlayerManager().getOrCreatePlayerData(victim);
        TeamColor victimTeam = victimData.getTeamColor();
        if (victimTeam != null) {
            this.plugin.getTeamManager().incrementTeamDeaths(victimTeam);
        }
    }

    private void handlePvpDeath(Player killer, Player victim) {
        PlayerData killerData = this.plugin.getPlayerManager().getOrCreatePlayerData(killer);
        PlayerData victimData = this.plugin.getPlayerManager().getOrCreatePlayerData(victim);
        TeamColor killerTeam = killerData.getTeamColor();
        TeamColor victimTeam = victimData.getTeamColor();
        boolean victimIsMurderer = this.plugin.getPlayerManager().isMurderer(victim.getUniqueId());
        if (victimIsMurderer) {
            killerData.incrementPkk();
            this.plugin.getPlayerManager().savePlayerData(killerData);
            if (killerTeam != null) {
                this.plugin.getTeamManager().incrementTeamKills(killerTeam);
            }
            if (victimTeam != null) {
                this.plugin.getTeamManager().incrementTeamDeaths(victimTeam);
            }
            Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&e" + killer.getName() + " &f\u304c Murderer &c" + victim.getName() + " &f\u3092\u5012\u3057\u307e\u3057\u305f\uff01"));
            this.plugin.getLogger().info(killer.getName() + " killed Murderer " + victim.getName() + " (PKK+1)");
        } else if (victimTeam != null) {
            this.plugin.getTeamManager().incrementTeamDeaths(victimTeam);
        }
    }

    private void applyMurdererPenalty(Player killer, Player victim, PlayerData killerData) {
        boolean shouldAnnounce;
        boolean isDifferentVictim;
        int durationSeconds = 180;
        boolean isFirstTime = this.plugin.getPlayerManager().setMurderer(killer.getUniqueId(), durationSeconds);
        UUID lastVictimUuid = this.lastVictims.get(killer.getUniqueId());
        boolean bl = isDifferentVictim = lastVictimUuid == null || !lastVictimUuid.equals(victim.getUniqueId());
        if (isDifferentVictim) {
            killerData.incrementPk();
            this.plugin.getPlayerManager().savePlayerData(killerData);
            this.plugin.getLogger().info("Player " + killer.getName() + " PK count increased (total: " + killerData.getPk() + ")");
        }
        this.lastVictims.put(killer.getUniqueId(), victim.getUniqueId());
        boolean bl2 = shouldAnnounce = isFirstTime || isDifferentVictim;
        if (isFirstTime) {
            this.removeArmor(killer);
            this.plugin.getBossManager().onPlayerBecomeMurderer(killer.getUniqueId());
            Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&c&l" + killer.getName() + " &f\u304c &e" + victim.getName() + " &f\u3092\u653b\u6483\u3057\u307e\u3057\u305f\uff01"));
            Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&c&l" + killer.getName() + " &f\u304cMurderer\u306b\u306a\u308a\u307e\u3057\u305f\uff01"));
            Bukkit.broadcastMessage((String)MessageUtils.colorize("&e\u9632\u5177\u304c\u5265\u596a\u3055\u308c\u3001\u6700\u592760\u5206\u9593\u88c5\u5099\u3067\u304d\u307e\u305b\u3093"));
            MessageUtils.sendTitle(killer, "&4&lMURDERER", "&c\u653b\u6483\u3054\u3068\u306b+3\u5206 (\u6700\u592760\u5206)");
            this.plugin.getLogger().warning("Player " + killer.getName() + " became a murderer (attacked " + victim.getName() + ")");
        } else if (shouldAnnounce) {
            Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&c&l" + killer.getName() + " &f\u304c &e" + victim.getName() + " &f\u3092\u653b\u6483\u3057\u307e\u3057\u305f\uff01"));
            this.plugin.getLogger().info("Player " + killer.getName() + " attacked " + victim.getName() + " (different victim, murderer time extended by 3 minutes)");
        } else {
            this.plugin.getLogger().info("Player " + killer.getName() + " attacked " + victim.getName() + " again (murderer time extended by 3 minutes)");
        }
    }

    private void removeArmor(Player player) {
        ItemStack boots;
        ItemStack leggings;
        ItemStack chestplate;
        ItemStack helmet = player.getInventory().getHelmet();
        if (helmet != null && helmet.getType() != Material.AIR) {
            player.getInventory().addItem(new ItemStack[]{helmet});
            player.getInventory().setHelmet(null);
        }
        if ((chestplate = player.getInventory().getChestplate()) != null && chestplate.getType() != Material.AIR) {
            player.getInventory().addItem(new ItemStack[]{chestplate});
            player.getInventory().setChestplate(null);
        }
        if ((leggings = player.getInventory().getLeggings()) != null && leggings.getType() != Material.AIR) {
            player.getInventory().addItem(new ItemStack[]{leggings});
            player.getInventory().setLeggings(null);
        }
        if ((boots = player.getInventory().getBoots()) != null && boots.getType() != Material.AIR) {
            player.getInventory().addItem(new ItemStack[]{boots});
            player.getInventory().setBoots(null);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        Player player = event.getPlayer();
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.plugin.getShopManager().giveShopItem(player), 5L);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onArmorEquip(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.plugin.getPlayerManager().isMurderer(player.getUniqueId())) {
            return;
        }
        int slot = event.getSlot();
        if (slot >= 36 && slot <= 39) {
            event.setCancelled(true);
            MessageUtils.sendActionBar(player, "&c&lMurderer\u72b6\u614b\u3067\u306f\u9632\u5177\u3092\u88c5\u5099\u3067\u304d\u307e\u305b\u3093\uff01");
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (item != null && item.getType() != Material.AIR && this.isArmor(item.getType()) && event.isShiftClick()) {
            event.setCancelled(true);
            MessageUtils.sendActionBar(player, "&c&lMurderer\u72b6\u614b\u3067\u306f\u9632\u5177\u3092\u88c5\u5099\u3067\u304d\u307e\u305b\u3093\uff01");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onArmorEquipInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        if (!this.plugin.getPlayerManager().isMurderer(player.getUniqueId())) {
            return;
        }
        ItemStack item = event.getItem();
        if (item != null && item.getType() != Material.AIR && this.isArmor(item.getType())) {
            event.setCancelled(true);
            MessageUtils.sendActionBar(player, "&c&lMurderer\u72b6\u614b\u3067\u306f\u9632\u5177\u3092\u88c5\u5099\u3067\u304d\u307e\u305b\u3093\uff01");
        }
    }

    private boolean isArmor(Material material) {
        String name = material.name();
        return name.endsWith("_HELMET") || name.endsWith("_CHESTPLATE") || name.endsWith("_LEGGINGS") || name.endsWith("_BOOTS");
    }
}

