/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.listeners;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.ChestType;
import com.candyrush.models.PlayerData;
import com.candyrush.utils.MessageUtils;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class TreasureChestListener
implements Listener {
    private final CandyRushPlugin plugin;
    private final Map<UUID, Location> openChests;

    public TreasureChestListener(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.openChests = new ConcurrentHashMap<UUID, Location>();
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onChestBreak(BlockBreakEvent event) {
        Block block = event.getBlock();
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        ChestType chestType = this.getChestType(block.getType());
        if (chestType == null) {
            return;
        }
        if (!this.plugin.getTreasureChestManager().isGameChest(block.getLocation())) {
            return;
        }
        Player player = event.getPlayer();
        event.setDropItems(false);
        if (block.getState() instanceof InventoryHolder) {
            InventoryHolder holder = (InventoryHolder)block.getState();
            Inventory inventory = holder.getInventory();
            inventory.clear();
        }
        Location loc = block.getLocation().add(0.5, 0.5, 0.5);
        block.getWorld().spawnParticle(Particle.CLOUD, loc, 20, 0.3, 0.3, 0.3, 0.05);
        block.getWorld().playSound(loc, Sound.BLOCK_WOOD_BREAK, 1.0f, 0.8f);
        MessageUtils.sendActionBar(player, "&7\u5b9d\u7bb1\u3092\u58ca\u3057\u305f - \u4e2d\u8eab\u306f\u6d88\u3048\u305f...");
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.plugin.getTreasureChestManager().onChestOpened(block.getLocation()));
        this.plugin.getLogger().fine("Player " + player.getName() + " broke chest at " + block.getX() + "," + block.getY() + "," + block.getZ() + " - items not dropped");
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onChestOpen(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block == null) {
            return;
        }
        if (!this.plugin.getGameManager().isGameRunning()) {
            return;
        }
        Player player = event.getPlayer();
        ChestType chestType = this.getChestType(block.getType());
        if (chestType == null) {
            return;
        }
        if (!this.plugin.getTreasureChestManager().isGameChest(block.getLocation())) {
            return;
        }
        if (chestType == ChestType.TRAPPED_CHEST) {
            this.handleTrappedChest(player, block);
        }
        Location chestLocation = block.getLocation();
        if (!this.openChests.containsKey(player.getUniqueId()) || !this.openChests.get(player.getUniqueId()).equals((Object)chestLocation)) {
            this.plugin.getPlayerManager().getPlayerData(player.getUniqueId()).ifPresent(data -> {
                data.incrementChestsOpened();
                this.plugin.getPlayerManager().savePlayerData((PlayerData)data);
            });
        }
        this.openChests.put(player.getUniqueId(), chestLocation);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory clickedInventory = event.getClickedInventory();
        if (clickedInventory == null || clickedInventory.getLocation() == null) {
            return;
        }
        Location chestLocation = clickedInventory.getLocation();
        if (!this.plugin.getTreasureChestManager().isGameChest(chestLocation)) {
            return;
        }
        Block block = chestLocation.getBlock();
        ChestType chestType = this.getChestType(block.getType());
        if (chestType == null) {
            return;
        }
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        if (this.isFoodItem(clickedItem.getType())) {
            event.setCancelled(true);
            int points = this.calculateFoodPoints(clickedItem);
            this.plugin.getPlayerManager().addPoints(player.getUniqueId(), points);
            MessageUtils.sendActionBar(player, "&e&l+" + points + "pt &7" + clickedItem.getType().name() + " x" + clickedItem.getAmount());
            player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 0.5f, 1.5f);
            clickedInventory.setItem(event.getSlot(), null);
            this.plugin.getLogger().fine("Player " + player.getName() + " got " + points + " points from " + clickedItem.getType().name() + " x" + clickedItem.getAmount());
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.checkAndCloseIfEmpty(player, chestLocation), 1L);
    }

    @EventHandler(priority=EventPriority.HIGH)
    public void onInventoryDrag(InventoryDragEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Inventory inventory = event.getInventory();
        if (inventory.getLocation() == null) {
            return;
        }
        Location chestLocation = inventory.getLocation();
        if (!this.plugin.getTreasureChestManager().isGameChest(chestLocation)) {
            return;
        }
        Block block = chestLocation.getBlock();
        ChestType chestType = this.getChestType(block.getType());
        if (chestType == null) {
            return;
        }
        ItemStack draggedItem = event.getOldCursor();
        if (draggedItem != null && this.isFoodItem(draggedItem.getType())) {
            event.setCancelled(true);
            Player player = (Player)event.getWhoClicked();
            MessageUtils.sendActionBar(player, "&c\u304a\u83d3\u5b50\u306f\u30af\u30ea\u30c3\u30af\u3057\u3066\u53d6\u5f97\u3057\u3066\u304f\u3060\u3055\u3044");
        }
    }

    private void checkAndCloseIfEmpty(Player player, Location chestLocation) {
        Block block = chestLocation.getBlock();
        if (!(block.getState() instanceof InventoryHolder)) {
            return;
        }
        InventoryHolder holder = (InventoryHolder)block.getState();
        Inventory inventory = holder.getInventory();
        if (this.isChestEmpty(inventory)) {
            player.closeInventory();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.deleteEmptyChest(block, player), 5L);
            this.openChests.remove(player.getUniqueId());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        this.openChests.remove(player.getUniqueId());
    }

    private boolean isChestEmpty(Inventory inventory) {
        for (ItemStack item : inventory.getContents()) {
            if (item == null || item.getType() == Material.AIR) continue;
            return false;
        }
        return true;
    }

    private void deleteEmptyChest(Block block, Player player) {
        Location loc = block.getLocation().add(0.5, 0.5, 0.5);
        block.getWorld().spawnParticle(Particle.CLOUD, loc, 30, 0.3, 0.3, 0.3, 0.1);
        block.getWorld().spawnParticle(Particle.SMOKE, loc, 15, 0.2, 0.2, 0.2, 0.05);
        block.getWorld().playSound(loc, Sound.BLOCK_FIRE_EXTINGUISH, 1.0f, 1.0f);
        block.getWorld().playSound(loc, Sound.ENTITY_GENERIC_EXTINGUISH_FIRE, 0.8f, 1.2f);
        block.setType(Material.AIR);
        MessageUtils.sendActionBar(player, "&7\u5b9d\u7bb1\u304c\u6d88\u3048\u305f...");
        this.plugin.getTreasureChestManager().onChestOpened(block.getLocation());
        this.plugin.getLogger().fine("Player " + player.getName() + " emptied chest at " + block.getX() + "," + block.getY() + "," + block.getZ() + " - chest removed");
    }

    private void handleTrappedChest(Player player, Block block) {
        double damage = this.plugin.getConfigManager().getTrappedChestDamage();
        player.damage(damage);
        MessageUtils.sendMessage(player, "&c&l\u30c8\u30e9\u30c3\u30d7\u3060\uff01 \u30c0\u30e1\u30fc\u30b8\u3092\u53d7\u3051\u305f\uff01");
        MessageUtils.sendActionBar(player, "&c&l\u26a0 \u30c8\u30e9\u30c3\u30d7\u30c1\u30a7\u30b9\u30c8 \u26a0");
        this.plugin.getLogger().fine("Player " + player.getName() + " triggered a trapped chest");
    }

    private boolean isFoodItem(Material material) {
        switch (material) {
            case COOKIE: 
            case CAKE: 
            case PUMPKIN_PIE: 
            case GOLDEN_APPLE: 
            case ENCHANTED_GOLDEN_APPLE: 
            case SWEET_BERRIES: 
            case GLOW_BERRIES: 
            case GOLDEN_CARROT: 
            case APPLE: 
            case MELON_SLICE: 
            case BREAD: 
            case COOKED_BEEF: 
            case COOKED_CHICKEN: 
            case COOKED_MUTTON: 
            case COOKED_PORKCHOP: 
            case COOKED_SALMON: 
            case COOKED_COD: 
            case BAKED_POTATO: 
            case CARROT: 
            case POTATO: 
            case BEETROOT: 
            case DRIED_KELP: 
            case TROPICAL_FISH: 
            case PUFFERFISH: 
            case BEEF: 
            case CHICKEN: 
            case MUTTON: 
            case PORKCHOP: 
            case RABBIT: 
            case SALMON: 
            case COD: {
                return true;
            }
        }
        return false;
    }

    private int calculateFoodPoints(ItemStack item) {
        int basePoints = 1;
        int amount = item.getAmount();
        switch (item.getType()) {
            case COOKIE: {
                basePoints = 2;
                break;
            }
            case CAKE: 
            case PUMPKIN_PIE: {
                basePoints = 5;
                break;
            }
            case GOLDEN_APPLE: {
                basePoints = 10;
                break;
            }
            case ENCHANTED_GOLDEN_APPLE: {
                basePoints = 20;
                break;
            }
            case SWEET_BERRIES: 
            case GLOW_BERRIES: {
                basePoints = 3;
                break;
            }
            case GOLDEN_CARROT: {
                basePoints = 8;
                break;
            }
            default: {
                basePoints = 1;
            }
        }
        return basePoints * amount;
    }

    private ChestType getChestType(Material material) {
        for (ChestType type : ChestType.values()) {
            if (type.getMaterial() != material) continue;
            return type;
        }
        return null;
    }
}

