/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.managers;

import com.candyrush.CandyRushPlugin;
import com.candyrush.managers.TeamManager;
import com.candyrush.models.GameRound;
import com.candyrush.models.GameState;
import com.candyrush.models.PlayerData;
import com.candyrush.models.TeamColor;
import com.candyrush.utils.LanguageManager;
import com.candyrush.utils.MessageUtils;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.StructureType;
import org.bukkit.World;
import org.bukkit.WorldBorder;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class GameManager {
    private final CandyRushPlugin plugin;
    private final LanguageManager lang;
    private GameState currentState;
    private GameRound currentRound;
    private BukkitTask countdownTask;
    private BukkitTask gameTimerTask;
    private BukkitTask cooldownTask;
    private BukkitTask timeCheckTask;
    private int countdownSeconds;
    private int gameTimeRemaining;
    private int cooldownSecondsRemaining;

    public GameManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLanguageManager();
        this.currentState = GameState.WAITING;
        this.currentRound = null;
    }

    public void initialize() {
        this.currentState = GameState.WAITING;
        this.resetWorldBorder();
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
            this.countdownTask = null;
        }
        if (this.gameTimerTask != null) {
            this.gameTimerTask.cancel();
            this.gameTimerTask = null;
        }
        if (this.cooldownTask != null) {
            this.cooldownTask.cancel();
            this.cooldownTask = null;
        }
        if (this.timeCheckTask != null) {
            this.timeCheckTask.cancel();
            this.timeCheckTask = null;
        }
        this.plugin.getLogger().info("GameManager initialized - State: WAITING");
    }

    public GameState getCurrentState() {
        return this.currentState;
    }

    public GameRound getCurrentRound() {
        return this.currentRound;
    }

    public boolean isGameRunning() {
        return this.currentState == GameState.RUNNING;
    }

    public boolean canJoinGame() {
        return this.currentState.canJoin();
    }

    public boolean canStartGame() {
        int minPlayers;
        if (!this.currentState.canStart()) {
            return false;
        }
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        return onlinePlayers >= (minPlayers = this.plugin.getConfigManager().getMinPlayers());
    }

    public void tryStartCountdown() {
        this.plugin.getLogger().info("tryStartCountdown called - Current state: " + String.valueOf((Object)this.currentState));
        if (this.currentState != GameState.WAITING) {
            this.plugin.getLogger().info("Cannot start countdown - not in WAITING state (current: " + String.valueOf((Object)this.currentState) + ")");
            return;
        }
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        int minPlayers = this.plugin.getConfigManager().getMinPlayers();
        this.plugin.getLogger().info("Player check - Online: " + onlinePlayers + ", Required: " + minPlayers);
        if (!this.canStartGame()) {
            this.plugin.getLogger().info("Cannot start game - insufficient players");
            return;
        }
        this.plugin.getLogger().info("Starting countdown!");
        this.startCountdown();
    }

    private void startCountdown() {
        this.currentState = GameState.COUNTDOWN;
        this.countdownSeconds = this.plugin.getConfigManager().getCountdownSeconds();
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("seconds", String.valueOf(this.countdownSeconds));
        Bukkit.broadcastMessage((String)this.lang.getMessageWithPrefix("game.countdown_start", placeholders));
        this.countdownTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (this.countdownSeconds <= 0) {
                this.countdownTask.cancel();
                this.startGame();
                return;
            }
            if (this.countdownSeconds <= 5) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    HashMap<String, String> titlePlaceholders = new HashMap<String, String>();
                    titlePlaceholders.put("seconds", String.valueOf(this.countdownSeconds));
                    MessageUtils.sendTitle(player, MessageUtils.formatCountdown(this.countdownSeconds), this.lang.getMessage("game.countdown_start", titlePlaceholders));
                }
            }
            if (this.countdownSeconds == 10 || this.countdownSeconds == 5 || this.countdownSeconds <= 3) {
                HashMap<String, String> msgPlaceholders = new HashMap<String, String>();
                msgPlaceholders.put("seconds", String.valueOf(this.countdownSeconds));
                Bukkit.broadcastMessage((String)this.lang.getMessageWithPrefix("game.countdown_start", msgPlaceholders));
            }
            --this.countdownSeconds;
        }, 0L, 20L);
        this.plugin.getLogger().info("Countdown started: " + this.countdownSeconds + " seconds");
    }

    public void cancelCountdown() {
        if (this.currentState != GameState.COUNTDOWN) {
            return;
        }
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
            this.countdownTask = null;
        }
        this.currentState = GameState.WAITING;
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("min", String.valueOf(this.plugin.getConfigManager().getMinPlayers()));
        Bukkit.broadcastMessage((String)this.lang.getMessageWithPrefix("game.insufficient_players", placeholders));
        this.plugin.getLogger().info("Countdown cancelled - insufficient players");
    }

    private void startGame() {
        int gameDuration;
        this.currentState = GameState.RUNNING;
        int playerCount = Bukkit.getOnlinePlayers().size();
        GameRound tempRound = new GameRound(playerCount);
        try {
            int roundId = this.plugin.getGameStateStorage().createGameRound(tempRound);
            this.plugin.getLogger().info("Game round created with ID: " + roundId);
            this.currentRound = new GameRound(roundId, tempRound.getStartedAt(), tempRound.getEndedAt(), tempRound.getWinnerTeam(), tempRound.getTotalPlayers(), tempRound.getDurationSeconds(), tempRound.getCreatedAt());
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save game round", e);
            this.currentRound = tempRound;
        }
        this.plugin.getTeamManager().distributePlayersEvenly(new ArrayList<Player>(Bukkit.getOnlinePlayers()));
        World world = (World)Bukkit.getWorlds().get(0);
        int mapRadius = this.plugin.getConfigManager().getMapRadius();
        Location centerLocation = this.getMapCenterLocation(world);
        this.plugin.getLogger().info("Map center: X=" + centerLocation.getBlockX() + ", Z=" + centerLocation.getBlockZ());
        this.setupTeamBasesAndTeleport(world, centerLocation, mapRadius);
        this.setupWorldConditions(world);
        this.plugin.getTreasureChestManager().spawnTreasureChests(world, centerLocation, mapRadius, this.currentRound.getId());
        this.plugin.getEventNpcManager().spawnEventNpcs(world, centerLocation, mapRadius, this.currentRound.getId());
        Bukkit.broadcastMessage((String)this.lang.getMessageWithPrefix("game.game_start"));
        for (Player player : Bukkit.getOnlinePlayers()) {
            MessageUtils.sendTitle(player, this.lang.getMessage("game.game_start"), "&e");
            player.setHealth(player.getMaxHealth());
            player.setFoodLevel(20);
            player.setSaturation(20.0f);
            player.getInventory().clear();
            player.getInventory().setHelmet(null);
            player.getInventory().setChestplate(null);
            player.getInventory().setLeggings(null);
            player.getInventory().setBoots(null);
            this.plugin.getPlayerManager().getPlayerData(player.getUniqueId()).ifPresent(data -> {
                data.setPoints(0);
                this.plugin.getPlayerManager().savePlayerData((PlayerData)data);
            });
            this.plugin.getPlayerManager().clearMurderer(player.getUniqueId());
            this.plugin.getShopManager().giveShopItem(player);
            player.setCanPickupItems(true);
        }
        this.setupNameTagVisibility();
        this.gameTimeRemaining = gameDuration = this.plugin.getConfigManager().getGameDurationMinutes() * 60;
        this.gameTimerTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            --this.gameTimeRemaining;
            if (this.gameTimeRemaining == 600 || this.gameTimeRemaining == 300 || this.gameTimeRemaining == 60 || this.gameTimeRemaining == 30 || this.gameTimeRemaining == 10) {
                Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&e\u6b8b\u308a\u6642\u9593: &c" + MessageUtils.formatTime(this.gameTimeRemaining)));
            }
            if (this.gameTimeRemaining % 10 == 0 || this.gameTimeRemaining <= 10) {
                for (Player player : Bukkit.getOnlinePlayers()) {
                    MessageUtils.sendActionBar(player, "&e\u6b8b\u308a\u6642\u9593: &c" + MessageUtils.formatTime(this.gameTimeRemaining));
                }
            }
            if (this.gameTimeRemaining <= 0) {
                this.gameTimerTask.cancel();
                this.endGame();
            }
        }, 20L, 20L);
        this.plugin.getLogger().info("Game started with " + playerCount + " players");
    }

    public void endGame() {
        if (this.currentState != GameState.RUNNING) {
            return;
        }
        if (this.gameTimerTask != null) {
            this.gameTimerTask.cancel();
            this.gameTimerTask = null;
        }
        this.stopTimeCheckTask();
        TeamColor winnerTeam = this.determineWinner();
        if (this.currentRound != null) {
            long now = System.currentTimeMillis() / 1000L;
            int duration = (int)(now - this.currentRound.getStartedAt());
            GameRound endedRound = new GameRound(this.currentRound.getId(), this.currentRound.getStartedAt(), now, winnerTeam, this.currentRound.getTotalPlayers(), duration, this.currentRound.getCreatedAt());
            try {
                this.plugin.getGameStateStorage().updateGameRound(endedRound);
                this.plugin.getLogger().info("Game round ended and saved");
            }
            catch (SQLException e) {
                this.plugin.getLogger().log(Level.SEVERE, "Failed to update game round", e);
            }
            this.currentRound = endedRound;
        }
        this.announceResults(winnerTeam);
        this.cleanupGame();
        this.startCooldown();
        this.plugin.getLogger().info("Game ended - Winner: " + String.valueOf(winnerTeam != null ? winnerTeam : "None"));
    }

    private void cleanupGame() {
        this.plugin.getTreasureChestManager().removeAllChests();
        this.plugin.getEventNpcManager().removeAllNpcs();
        this.plugin.getBossManager().removeAllBosses();
        this.plugin.getTeamManager().resetAllTeams();
        this.plugin.getLogger().info("Game cleanup completed");
    }

    private TeamColor determineWinner() {
        TeamManager teamManager = this.plugin.getTeamManager();
        if (teamManager == null) {
            return null;
        }
        if (teamManager.isTie()) {
            return null;
        }
        return teamManager.getWinningTeam().orElse(null);
    }

    private void announceResults(TeamColor winnerTeam) {
        Bukkit.broadcastMessage((String)this.lang.getMessageWithPrefix("game.game_end"));
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (winnerTeam != null) {
                MessageUtils.sendTitle(player, this.lang.getMessage("game.game_end"), winnerTeam.getFormattedName());
                continue;
            }
            MessageUtils.sendTitle(player, this.lang.getMessage("game.game_end"), "");
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.displayGameResults(winnerTeam), 60L);
    }

    /*
     * WARNING - void declaration
     */
    private void displayGameResults(TeamColor winnerTeam) {
        Bukkit.broadcastMessage((String)"");
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&6&l========================================"));
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&e&l          \u30c1\u30fc\u30e0\u30e9\u30f3\u30ad\u30f3\u30b0"));
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&6&l========================================"));
        TeamManager teamManager = this.plugin.getTeamManager();
        List<TeamColor> gameTeams = Arrays.asList(TeamColor.BLUE, TeamColor.GREEN, TeamColor.YELLOW);
        ArrayList<AbstractMap.SimpleEntry<TeamColor, Integer>> teamScores = new ArrayList<AbstractMap.SimpleEntry<TeamColor, Integer>>();
        for (TeamColor teamColor : gameTeams) {
            int n = teamManager.getTeamPoints(teamColor);
            teamScores.add(new AbstractMap.SimpleEntry<TeamColor, Integer>(teamColor, n));
        }
        teamScores.sort((a, b) -> ((Integer)b.getValue()).compareTo((Integer)a.getValue()));
        int rank = 1;
        for (Map.Entry entry : teamScores) {
            TeamColor team = (TeamColor)((Object)entry.getKey());
            int points = (Integer)entry.getValue();
            int totalChests = 0;
            int totalEvents = 0;
            int totalPk = 0;
            int totalPkk = 0;
            for (PlayerData data : this.plugin.getPlayerManager().getAllPlayers()) {
                if (data.getTeamColor() != team) continue;
                totalChests += data.getChestsOpened();
                totalEvents += data.getEventsCompleted();
                totalPk += data.getPk();
                totalPkk += data.getPkk();
            }
            String rankMedal = rank == 1 ? "&6&l" + rank + "\u4f4d " : (rank == 2 ? "&7&l" + rank + "\u4f4d " : "&c&l" + rank + "\u4f4d ");
            String teamDisplay = String.valueOf(team.getChatColor()) + team.getFormattedName();
            Bukkit.broadcastMessage((String)MessageUtils.colorize(rankMedal + teamDisplay));
            Bukkit.broadcastMessage((String)MessageUtils.colorize("  &f\u5408\u8a08\u30dd\u30a4\u30f3\u30c8: &e" + points + "pt"));
            Bukkit.broadcastMessage((String)MessageUtils.colorize("  &f\u5b9d\u7bb1: &a" + totalChests + " &f| \u30a4\u30d9\u30f3\u30c8: &a" + totalEvents));
            Bukkit.broadcastMessage((String)MessageUtils.colorize("  &fPK: &c" + totalPk + " &f| PKK: &b" + totalPkk));
            ++rank;
        }
        Bukkit.broadcastMessage((String)"");
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&6&l========================================"));
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&e&l          \u500b\u4eba\u30e9\u30f3\u30ad\u30f3\u30b0 TOP10"));
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&6&l========================================"));
        List<PlayerData> list = this.plugin.getPlayerManager().getAllPlayers();
        list.sort((a, b) -> Integer.compare(b.getPoints(), a.getPoints()));
        boolean bl = true;
        for (PlayerData data : list) {
            void var7_13;
            if (var7_13 > 10) break;
            String rankDisplay = var7_13 == true ? "&6&l\u2605" + (int)var7_13 + "\u4f4d " : (var7_13 == 2 ? "&7&l\u25c6" + (int)var7_13 + "\u4f4d " : (var7_13 == 3 ? "&c&l\u25b2" + (int)var7_13 + "\u4f4d " : "&f" + (int)var7_13 + "\u4f4d "));
            TeamColor playerTeam = data.getTeamColor();
            String teamDisplay = playerTeam != null ? String.valueOf(playerTeam.getChatColor()) : "&7";
            Bukkit.broadcastMessage((String)MessageUtils.colorize(rankDisplay + teamDisplay + data.getName() + " &7- &e" + data.getPoints() + "pt"));
            Bukkit.broadcastMessage((String)MessageUtils.colorize("  &f\u5b9d\u7bb1: &a" + data.getChestsOpened() + " &f| \u30a4\u30d9\u30f3\u30c8: &a" + data.getEventsCompleted() + " &f| PK: &c" + data.getPk() + " &f| PKK: &b" + data.getPkk()));
            ++var7_13;
        }
        Bukkit.broadcastMessage((String)MessageUtils.colorize("&6&l========================================"));
        Bukkit.broadcastMessage((String)"");
    }

    private void startCooldown() {
        this.currentState = GameState.COOLDOWN;
        this.cooldownSecondsRemaining = this.plugin.getConfigManager().getCooldownMinutes() * 60;
        Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&e\u6b21\u306e\u30b2\u30fc\u30e0\u307e\u3067 &c" + this.plugin.getConfigManager().getCooldownMinutes() + "\u5206 &e\u304a\u5f85\u3061\u304f\u3060\u3055\u3044"));
        this.cooldownTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            --this.cooldownSecondsRemaining;
            if (this.cooldownSecondsRemaining <= 0) {
                this.cooldownTask.cancel();
                this.endCooldown();
            }
        }, 20L, 20L);
        this.plugin.getLogger().info("Cooldown started: " + this.plugin.getConfigManager().getCooldownMinutes() + " minutes");
    }

    private void endCooldown() {
        this.currentState = GameState.WAITING;
        this.currentRound = null;
        Bukkit.broadcastMessage((String)MessageUtils.colorize(this.plugin.getConfigManager().getPrefix() + "&a\u30af\u30fc\u30eb\u30c0\u30a6\u30f3\u304c\u7d42\u4e86\u3057\u307e\u3057\u305f\uff01"));
        this.tryStartCountdown();
        this.plugin.getLogger().info("Cooldown ended - State: WAITING");
    }

    public int getGameTimeRemaining() {
        return this.gameTimeRemaining;
    }

    public int getCooldownSecondsRemaining() {
        return this.cooldownSecondsRemaining;
    }

    private Location getMapCenterLocation(World world) {
        Integer centerX = this.plugin.getConfigManager().getMapCenterX();
        Integer centerZ = this.plugin.getConfigManager().getMapCenterZ();
        if (centerX != null && centerZ != null) {
            int y = world.getHighestBlockYAt(centerX.intValue(), centerZ.intValue());
            this.plugin.getLogger().info("Using configured map center: X=" + centerX + ", Z=" + centerZ);
            return new Location(world, (double)centerX.intValue(), (double)y, (double)centerZ.intValue());
        }
        this.plugin.getLogger().info("Searching for nearby structures to use as map center...");
        Location structureLocation = this.findRandomStructure(world);
        if (structureLocation != null) {
            this.plugin.getLogger().info("Using random structure as map center: X=" + structureLocation.getBlockX() + ", Z=" + structureLocation.getBlockZ());
            return structureLocation;
        }
        Location spawn = world.getSpawnLocation();
        this.plugin.getLogger().warning("No structures found nearby, using world spawn as map center: X=" + spawn.getBlockX() + ", Z=" + spawn.getBlockZ());
        return spawn;
    }

    private Location findRandomStructure(World world) {
        Location spawnLocation = world.getSpawnLocation();
        int searchRadius = 2000;
        ArrayList<StructureType> targetStructures = new ArrayList<StructureType>();
        targetStructures.add(StructureType.VILLAGE);
        targetStructures.add(StructureType.PILLAGER_OUTPOST);
        targetStructures.add(StructureType.DESERT_PYRAMID);
        targetStructures.add(StructureType.JUNGLE_PYRAMID);
        targetStructures.add(StructureType.SWAMP_HUT);
        targetStructures.add(StructureType.IGLOO);
        if (targetStructures.isEmpty()) {
            this.plugin.getLogger().warning("No structure types available for search");
            return null;
        }
        ArrayList<Location> foundStructures = new ArrayList<Location>();
        for (StructureType structureType : targetStructures) {
            try {
                Location found = world.locateNearestStructure(spawnLocation, structureType, searchRadius, false);
                if (found == null) continue;
                int x = found.getBlockX();
                int z = found.getBlockZ();
                int y = world.getHighestBlockYAt(x, z);
                Location surfaceLocation = new Location(world, (double)x, (double)y, (double)z);
                foundStructures.add(surfaceLocation);
                this.plugin.getLogger().info("Found structure: " + structureType.getName() + " at X=" + x + ", Z=" + z);
            }
            catch (Exception e) {
                this.plugin.getLogger().fine("Could not find structure " + structureType.getName() + ": " + e.getMessage());
            }
        }
        if (foundStructures.isEmpty()) {
            this.plugin.getLogger().warning("No structures found within " + searchRadius + " blocks");
            return null;
        }
        Collections.shuffle(foundStructures);
        Location selected = (Location)foundStructures.get(0);
        this.plugin.getLogger().info("Randomly selected structure from " + foundStructures.size() + " candidates");
        return selected;
    }

    private void setupTeamBasesAndTeleport(World world, Location center, int mapRadius) {
        long delay = 5L;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                int randomRadius = 50;
                double angle = Math.random() * 2.0 * Math.PI;
                double distance = Math.random() * (double)randomRadius;
                int x = (int)((double)center.getBlockX() + distance * Math.cos(angle));
                int z = (int)((double)center.getBlockZ() + distance * Math.sin(angle));
                int y = world.getHighestBlockYAt(x, z) + 1;
                Location spawnLocation = new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5);
                spawnLocation.setYaw((float)(Math.random() * 360.0));
                player.teleport(spawnLocation);
                this.plugin.getLogger().info("Teleported " + player.getName() + " to random center location (X=" + x + ", Y=" + y + ", Z=" + z + ")");
            }
        }, delay);
        long borderDelay = delay + 10L;
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.setupMapBarrier(world, center, mapRadius);
            this.plugin.getLogger().info("World border activated after all players teleported");
        }, borderDelay);
    }

    private void placeTeamConcrete(Location center, TeamColor teamColor) {
        Material concreteType = this.getConcreteTypeForTeam(teamColor);
        World world = center.getWorld();
        for (int x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                int blockX = center.getBlockX() + x;
                int blockZ = center.getBlockZ() + z;
                int groundY = this.findNaturalGroundLevel(world, blockX, blockZ, center.getBlockY());
                Location concreteLocation = new Location(world, (double)blockX, (double)groundY, (double)blockZ);
                concreteLocation.getBlock().setType(concreteType);
            }
        }
        this.plugin.getLogger().info("Placed " + String.valueOf((Object)teamColor) + " concrete at team base");
    }

    private int findNaturalGroundLevel(World world, int x, int z, int startY) {
        for (int y = startY - 1; y >= startY - 10; --y) {
            Block block = world.getBlockAt(x, y, z);
            Material material = block.getType();
            if (material == Material.RED_CONCRETE || material == Material.BLUE_CONCRETE || material == Material.GREEN_CONCRETE || material == Material.YELLOW_CONCRETE || material == Material.WHITE_CONCRETE || material == Material.BARRIER || !material.isSolid() || material == Material.AIR) continue;
            return y + 1;
        }
        return startY;
    }

    private Material getConcreteTypeForTeam(TeamColor teamColor) {
        switch (teamColor) {
            case RED: {
                return Material.RED_CONCRETE;
            }
            case BLUE: {
                return Material.BLUE_CONCRETE;
            }
            case GREEN: {
                return Material.GREEN_CONCRETE;
            }
            case YELLOW: {
                return Material.YELLOW_CONCRETE;
            }
        }
        return Material.WHITE_CONCRETE;
    }

    private void setupMapBarrier(World world, Location center, int mapRadius) {
        WorldBorder border = world.getWorldBorder();
        border.setCenter(center);
        border.setSize((double)mapRadius * 2.0);
        border.setWarningDistance(10);
        border.setDamageAmount(0.2);
        border.setDamageBuffer(5.0);
        this.plugin.getLogger().info("World border set at center X=" + center.getBlockX() + ", Z=" + center.getBlockZ() + ", radius=" + mapRadius);
    }

    private void setupWorldConditions(World world) {
        String weatherConfig = this.plugin.getConfigManager().getWeather();
        switch (weatherConfig.toUpperCase()) {
            case "CLEAR": {
                world.setStorm(false);
                world.setThundering(false);
                break;
            }
            case "RAIN": {
                world.setStorm(true);
                world.setThundering(false);
                break;
            }
            case "THUNDER": {
                world.setStorm(true);
                world.setThundering(true);
            }
        }
        world.setTime(0L);
        this.plugin.getLogger().info("World conditions set - Weather: " + weatherConfig + ", Time: Morning");
        if (this.plugin.getConfigManager().isAutoMorning()) {
            this.startTimeCheckTask(world);
        }
    }

    private void startTimeCheckTask(World world) {
        if (this.timeCheckTask != null) {
            this.timeCheckTask.cancel();
        }
        this.timeCheckTask = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            if (this.currentState != GameState.RUNNING) {
                return;
            }
            long time = world.getTime();
            if (time >= 13000L) {
                world.setTime(0L);
                this.plugin.getLogger().fine("Time reset to morning (night detected)");
            }
        }, 200L, 200L);
        this.plugin.getLogger().info("Time check task started - Auto-morning enabled");
    }

    private void stopTimeCheckTask() {
        if (this.timeCheckTask != null) {
            this.timeCheckTask.cancel();
            this.timeCheckTask = null;
            this.plugin.getLogger().info("Time check task stopped");
        }
    }

    private void setupNameTagVisibility() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.plugin.getScoreboardManager().setupScoreboard(player);
        }
        this.plugin.getLogger().info("Setup team colors and name tag visibility for all players");
    }

    public void shutdown() {
        if (this.countdownTask != null) {
            this.countdownTask.cancel();
        }
        if (this.gameTimerTask != null) {
            this.gameTimerTask.cancel();
        }
        if (this.cooldownTask != null) {
            this.cooldownTask.cancel();
        }
        if (this.timeCheckTask != null) {
            this.timeCheckTask.cancel();
        }
        this.resetWorldBorder();
        if (this.isGameRunning()) {
            this.cleanupGame();
        }
        this.plugin.getLogger().info("GameManager shutdown complete");
    }

    private void resetWorldBorder() {
        for (World world : Bukkit.getWorlds()) {
            WorldBorder border = world.getWorldBorder();
            border.setSize(5.9999968E7);
            border.setCenter(0.0, 0.0);
            border.setWarningDistance(5);
            border.setDamageAmount(0.2);
            border.setDamageBuffer(5.0);
            this.plugin.getLogger().info("Reset world border for world: " + world.getName());
        }
    }
}

