/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.managers;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.PlayerData;
import com.candyrush.models.Team;
import com.candyrush.models.TeamColor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;

public class TeamManager {
    private final CandyRushPlugin plugin;
    private final Map<TeamColor, Team> teams;

    public TeamManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.teams = new EnumMap<TeamColor, Team>(TeamColor.class);
    }

    public void initialize() {
        for (TeamColor color : TeamColor.values()) {
            this.teams.put(color, new Team(color));
        }
        this.plugin.getLogger().info("TeamManager initialized - 4 teams created");
    }

    public Team getTeam(TeamColor color) {
        return this.teams.get((Object)color);
    }

    public Collection<Team> getAllTeams() {
        return this.teams.values();
    }

    public Optional<Team> getPlayerTeam(UUID playerUuid) {
        for (Team team : this.teams.values()) {
            if (!team.hasPlayer(playerUuid)) continue;
            return Optional.of(team);
        }
        return Optional.empty();
    }

    public void assignPlayerToTeam(UUID playerUuid, TeamColor teamColor) {
        this.removePlayerFromAllTeams(playerUuid);
        Team team = this.teams.get((Object)teamColor);
        if (team != null) {
            team.addPlayer(playerUuid);
            this.plugin.getLogger().fine("Player " + String.valueOf(playerUuid) + " assigned to " + String.valueOf((Object)teamColor) + " team");
        }
        this.plugin.getPlayerManager().getPlayerData(playerUuid).ifPresent(data -> {
            data.setTeamColor(teamColor);
            this.plugin.getPlayerManager().savePlayerData((PlayerData)data);
        });
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player != null && player.isOnline()) {
            this.plugin.getPlayerManager().updatePlayerTeamColor(player);
        }
    }

    public void removePlayerFromAllTeams(UUID playerUuid) {
        for (Team team : this.teams.values()) {
            team.removePlayer(playerUuid);
        }
        this.plugin.getPlayerManager().getPlayerData(playerUuid).ifPresent(data -> {
            data.setTeamColor(null);
            this.plugin.getPlayerManager().savePlayerData((PlayerData)data);
        });
    }

    public void distributePlayersEvenly(Collection<Player> players) {
        this.resetAllTeams();
        ArrayList<Player> playerList = new ArrayList<Player>(players);
        Collections.shuffle(playerList);
        TeamColor[] gameTeams = new TeamColor[]{TeamColor.BLUE, TeamColor.GREEN, TeamColor.YELLOW};
        int teamIndex = 0;
        for (Player player : playerList) {
            TeamColor color = gameTeams[teamIndex % gameTeams.length];
            this.assignPlayerToTeam(player.getUniqueId(), color);
            ++teamIndex;
        }
        this.plugin.getLogger().info("Distributed " + players.size() + " players across 3 teams (BLUE, GREEN, YELLOW)");
        for (TeamColor color : gameTeams) {
            Team team = this.teams.get((Object)color);
            this.plugin.getLogger().info(String.valueOf((Object)color) + " team: " + team.getPlayerCount() + " players");
        }
    }

    public TeamColor getSmallestTeam() {
        TeamColor[] gameTeams = new TeamColor[]{TeamColor.BLUE, TeamColor.GREEN, TeamColor.YELLOW};
        TeamColor smallest = TeamColor.BLUE;
        int minCount = Integer.MAX_VALUE;
        for (TeamColor color : gameTeams) {
            Team team = this.teams.get((Object)color);
            if (team == null || team.getPlayerCount() >= minCount) continue;
            minCount = team.getPlayerCount();
            smallest = color;
        }
        return smallest;
    }

    public void addTeamPoints(TeamColor color, int points) {
        Team team = this.teams.get((Object)color);
        if (team != null) {
            team.addPoints(points);
        }
    }

    public void incrementTeamKills(TeamColor color) {
        Team team = this.teams.get((Object)color);
        if (team != null) {
            team.incrementKills();
        }
    }

    public void incrementTeamDeaths(TeamColor color) {
        Team team = this.teams.get((Object)color);
        if (team != null) {
            team.incrementDeaths();
        }
    }

    public Optional<TeamColor> getWinningTeam() {
        return this.teams.values().stream().max(Comparator.comparingInt(Team::getPoints)).map(Team::getColor);
    }

    public boolean isTie() {
        if (this.teams.isEmpty()) {
            return true;
        }
        int maxPoints = this.teams.values().stream().mapToInt(Team::getPoints).max().orElse(0);
        long teamsWithMaxPoints = this.teams.values().stream().filter(team -> team.getPoints() == maxPoints).count();
        return teamsWithMaxPoints > 1L;
    }

    public List<Team> getTeamRanking() {
        ArrayList<Team> ranking = new ArrayList<Team>(this.teams.values());
        ranking.sort((t1, t2) -> Integer.compare(t2.getPoints(), t1.getPoints()));
        return ranking;
    }

    public void resetAllTeams() {
        for (Team team : this.teams.values()) {
            team.reset();
        }
        this.plugin.getLogger().info("All teams reset");
    }

    public Map<TeamColor, Map<String, Object>> getTeamStatistics() {
        EnumMap<TeamColor, Map<String, Object>> stats = new EnumMap<TeamColor, Map<String, Object>>(TeamColor.class);
        for (TeamColor color : TeamColor.values()) {
            Team team = this.teams.get((Object)color);
            HashMap<String, Number> teamStats = new HashMap<String, Number>();
            teamStats.put("players", team.getPlayerCount());
            teamStats.put("points", team.getPoints());
            teamStats.put("kills", team.getKills());
            teamStats.put("deaths", team.getDeaths());
            teamStats.put("kd_ratio", team.getKDRatio());
            stats.put(color, teamStats);
        }
        return stats;
    }

    public void saveTeamScoresToDatabase(int roundId) {
        for (Team team : this.teams.values()) {
            try {
                this.plugin.getGameStateStorage().saveTeamScore(roundId, team.getColor(), team.getPoints(), team.getKills(), team.getDeaths(), team.getPlayerCount());
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to save team score for " + String.valueOf((Object)team.getColor()) + ": " + e.getMessage());
            }
        }
        this.plugin.getLogger().info("Team scores saved to database for round " + roundId);
    }

    public int getTotalPoints() {
        return this.teams.values().stream().mapToInt(Team::getPoints).sum();
    }

    public int getTeamPoints(TeamColor teamColor) {
        Team team = this.teams.get((Object)teamColor);
        return team != null ? team.getPoints() : 0;
    }

    public Location getTeamSpawnLocation(World world, Location center, int mapRadius, TeamColor teamColor) {
        int offsetX = 0;
        int offsetZ = 0;
        int offset = mapRadius - 20;
        switch (teamColor) {
            case RED: {
                offsetX = offset;
                offsetZ = -offset;
                break;
            }
            case BLUE: {
                offsetX = -offset;
                offsetZ = -offset;
                break;
            }
            case GREEN: {
                offsetX = -offset;
                offsetZ = offset;
                break;
            }
            case YELLOW: {
                offsetX = offset;
                offsetZ = offset;
            }
        }
        int x = center.getBlockX() + offsetX;
        int z = center.getBlockZ() + offsetZ;
        int y = world.getHighestBlockYAt(x, z) + 1;
        return new Location(world, (double)x + 0.5, (double)y, (double)z + 0.5, 0.0f, 0.0f);
    }

    public void shutdown() {
        this.resetAllTeams();
        this.plugin.getLogger().info("TeamManager shutdown complete");
    }
}

