/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.models;

import com.candyrush.models.ChestLootCategory;
import org.bukkit.Material;

public enum ChestType {
    CHEST(Material.CHEST, false, ChestLootCategory.FOOD),
    LARGE_CHEST(Material.CHEST, false, ChestLootCategory.FOOD),
    BARREL(Material.BARREL, false, ChestLootCategory.FOOD),
    FURNACE(Material.FURNACE, false, ChestLootCategory.MATERIAL),
    BLAST_FURNACE(Material.BLAST_FURNACE, false, ChestLootCategory.MATERIAL),
    SMOKER(Material.SMOKER, false, ChestLootCategory.MATERIAL),
    BREWING_STAND(Material.BREWING_STAND, false, ChestLootCategory.POTION),
    HOPPER(Material.HOPPER, false, ChestLootCategory.UTILITY),
    DROPPER(Material.DROPPER, false, ChestLootCategory.EQUIPMENT),
    DISPENSER(Material.DISPENSER, false, ChestLootCategory.EQUIPMENT),
    TRAPPED_CHEST(Material.TRAPPED_CHEST, true, ChestLootCategory.TRAP_REWARD);

    private final Material material;
    private final boolean isTrapped;
    private final ChestLootCategory lootCategory;

    private ChestType(Material material, boolean isTrapped, ChestLootCategory lootCategory) {
        this.material = material;
        this.isTrapped = isTrapped;
        this.lootCategory = lootCategory;
    }

    public Material getMaterial() {
        return this.material;
    }

    public boolean isTrapped() {
        return this.isTrapped;
    }

    public ChestLootCategory getLootCategory() {
        return this.lootCategory;
    }

    public boolean isContainer() {
        return this.material.toString().contains("CHEST") || this.material.toString().contains("BARREL") || this.material.toString().contains("FURNACE") || this.material.toString().contains("SMOKER") || this.material.toString().contains("BREWING_STAND") || this.material.toString().contains("HOPPER") || this.material.toString().contains("DROPPER") || this.material.toString().contains("DISPENSER");
    }

    public static ChestType random() {
        double rand = Math.random() * 100.0;
        if (rand < 70.0) {
            return CHEST;
        }
        if (rand < 73.0) {
            return TRAPPED_CHEST;
        }
        ChestType[] others = new ChestType[]{LARGE_CHEST, BARREL, FURNACE, BLAST_FURNACE, SMOKER, BREWING_STAND, HOPPER, DROPPER, DISPENSER};
        return others[(int)(Math.random() * (double)others.length)];
    }

    public static ChestType randomNormal() {
        ChestType type;
        while ((type = ChestType.random()).isTrapped()) {
        }
        return type;
    }
}

