/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.models;

import com.candyrush.models.TeamColor;
import java.util.UUID;

public class PlayerData {
    private final UUID uuid;
    private String name;
    private TeamColor teamColor;
    private int points;
    private int pk;
    private int pkk;
    private int chestsOpened;
    private int eventsCompleted;
    private boolean isMurderer;
    private long murdererUntil;
    private long lastSeen;
    private final long createdAt;
    private long updatedAt;

    public PlayerData(UUID uuid, String name) {
        long now;
        this.uuid = uuid;
        this.name = name;
        this.teamColor = null;
        this.points = 0;
        this.pk = 0;
        this.pkk = 0;
        this.chestsOpened = 0;
        this.eventsCompleted = 0;
        this.isMurderer = false;
        this.murdererUntil = 0L;
        this.lastSeen = now = System.currentTimeMillis() / 1000L;
        this.createdAt = now;
        this.updatedAt = now;
    }

    public PlayerData(UUID uuid, String name, TeamColor teamColor, int points, int pk, int pkk, int chestsOpened, int eventsCompleted, boolean isMurderer, long murdererUntil, long lastSeen, long createdAt, long updatedAt) {
        this.uuid = uuid;
        this.name = name;
        this.teamColor = teamColor;
        this.points = points;
        this.pk = pk;
        this.pkk = pkk;
        this.chestsOpened = chestsOpened;
        this.eventsCompleted = eventsCompleted;
        this.isMurderer = isMurderer;
        this.murdererUntil = murdererUntil;
        this.lastSeen = lastSeen;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public TeamColor getTeamColor() {
        return this.teamColor;
    }

    public int getPoints() {
        return this.points;
    }

    public int getPk() {
        return this.pk;
    }

    public int getPkk() {
        return this.pkk;
    }

    public int getChestsOpened() {
        return this.chestsOpened;
    }

    public int getEventsCompleted() {
        return this.eventsCompleted;
    }

    public boolean isMurderer() {
        return this.isMurderer;
    }

    public long getMurdererUntil() {
        return this.murdererUntil;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setName(String name) {
        this.name = name;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setTeamColor(TeamColor teamColor) {
        this.teamColor = teamColor;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setPoints(int points) {
        this.points = points;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void addPoints(int amount) {
        this.points += amount;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setPk(int pk) {
        this.pk = pk;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void incrementPk() {
        ++this.pk;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setPkk(int pkk) {
        this.pkk = pkk;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void incrementPkk() {
        ++this.pkk;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setChestsOpened(int chestsOpened) {
        this.chestsOpened = chestsOpened;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void incrementChestsOpened() {
        ++this.chestsOpened;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setEventsCompleted(int eventsCompleted) {
        this.eventsCompleted = eventsCompleted;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void incrementEventsCompleted() {
        ++this.eventsCompleted;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setMurderer(boolean isMurderer) {
        this.isMurderer = isMurderer;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setMurdererUntil(long murdererUntil) {
        this.murdererUntil = murdererUntil;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void updateLastSeen() {
        this.updatedAt = this.lastSeen = System.currentTimeMillis() / 1000L;
    }

    public boolean isMurdererActive() {
        if (!this.isMurderer) {
            return false;
        }
        long now = System.currentTimeMillis() / 1000L;
        return now < this.murdererUntil;
    }

    public void clearMurderer() {
        this.isMurderer = false;
        this.murdererUntil = 0L;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void resetForNewGame() {
        this.teamColor = null;
        this.points = 0;
        this.chestsOpened = 0;
        this.eventsCompleted = 0;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public double getKDRatio() {
        if (this.pk == 0) {
            return this.pkk;
        }
        return (double)this.pkk / (double)this.pk;
    }

    public String toString() {
        return "PlayerData{uuid=" + String.valueOf(this.uuid) + ", name='" + this.name + "', teamColor=" + String.valueOf((Object)this.teamColor) + ", points=" + this.points + ", pk=" + this.pk + ", pkk=" + this.pkk + ", isMurderer=" + this.isMurderer + "}";
    }
}

