/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.models;

import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionType;

public class ShopItem {
    private final String id;
    private final String name;
    private final Material material;
    private final int amount;
    private final int price;
    private final PotionType potionType;
    private final String category;

    public ShopItem(String id, String name, Material material, int amount, int price, PotionType potionType, String category) {
        this.id = id;
        this.name = name;
        this.material = material;
        this.amount = amount;
        this.price = price;
        this.potionType = potionType;
        this.category = category;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getAmount() {
        return this.amount;
    }

    public int getPrice() {
        return this.price;
    }

    public PotionType getPotionType() {
        return this.potionType;
    }

    public String getCategory() {
        return this.category;
    }

    public ItemStack createItemStack() {
        ItemStack item = new ItemStack(this.material, this.amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName("\u00a7r" + this.name);
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add("\u00a76\u4fa1\u683c: " + this.price + "pt");
            lore.add("");
            lore.add("\u00a77\u30af\u30ea\u30c3\u30af\u3067\u8cfc\u5165");
            meta.setLore(lore);
            if (meta instanceof PotionMeta && this.potionType != null) {
                PotionMeta potionMeta = (PotionMeta)meta;
                potionMeta.setBasePotionType(this.potionType);
            }
            item.setItemMeta(meta);
        }
        return item;
    }

    public ItemStack createPurchasedItem() {
        ItemMeta meta;
        ItemStack item = new ItemStack(this.material, this.amount);
        if (this.potionType != null && (meta = item.getItemMeta()) instanceof PotionMeta) {
            PotionMeta potionMeta = (PotionMeta)meta;
            potionMeta.setBasePotionType(this.potionType);
            item.setItemMeta((ItemMeta)potionMeta);
        }
        return item;
    }
}

