/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.utils;

import com.candyrush.CandyRushPlugin;
import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class ConfigManager {
    private final CandyRushPlugin plugin;
    private final FileConfiguration config;

    public ConfigManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
    }

    public String getLanguage() {
        return this.config.getString("language", "ja");
    }

    public int getMinPlayers() {
        return this.config.getInt("game.min-players", 2);
    }

    public int getCountdownSeconds() {
        return this.config.getInt("game.countdown-seconds", 10);
    }

    public int getCooldownMinutes() {
        return this.config.getInt("game.cooldown-minutes", 5);
    }

    public int getGameDurationMinutes() {
        return this.config.getInt("game.duration-minutes", 20);
    }

    public int getMapRadius() {
        return this.config.getInt("game.map-radius", 250);
    }

    public Integer getMapCenterX() {
        if (this.config.isSet("game.center-x") && this.config.get("game.center-x") != null) {
            return this.config.getInt("game.center-x");
        }
        return null;
    }

    public Integer getMapCenterZ() {
        if (this.config.isSet("game.center-z") && this.config.get("game.center-z") != null) {
            return this.config.getInt("game.center-z");
        }
        return null;
    }

    public void setMapCenter(int x, int z) {
        this.config.set("game.center-x", (Object)x);
        this.config.set("game.center-z", (Object)z);
        this.plugin.saveConfig();
    }

    public void clearMapCenter() {
        this.config.set("game.center-x", null);
        this.config.set("game.center-z", null);
        this.plugin.saveConfig();
    }

    public int getTreasurePerChunk() {
        return this.config.getInt("treasure.per-chunk", 1);
    }

    public double getTrappedChestDamage() {
        return this.config.getDouble("treasure.trapped-chest-damage", 4.0);
    }

    public double getTrappedChestEquipmentChance() {
        return this.config.getDouble("treasure.trapped-chest-equipment-chance", 0.7);
    }

    public int getTreasureRespawnDelay() {
        return this.config.getInt("treasure.respawn-delay-seconds", 60);
    }

    public int getEventNpcPerChunks() {
        return this.config.getInt("event.npc-per-chunks", 3);
    }

    public int getProximityRange() {
        return this.config.getInt("event.proximity-range", 10);
    }

    public int getHelpMessageCooldown() {
        return this.config.getInt("event.help-message-cooldown", 5);
    }

    public int getDefenseDurationSeconds() {
        return this.config.getInt("event.defense-duration-seconds", 120);
    }

    public int getMonsterWaves() {
        return this.config.getInt("event.monster-waves", 3);
    }

    public int getMonstersPerWave() {
        return this.config.getInt("event.monsters-per-wave", 5);
    }

    public int getWaveIntervalSeconds() {
        return this.config.getInt("event.wave-interval-seconds", 30);
    }

    public int getRewardPointsMin() {
        return this.config.getInt("event.reward-points-min", 50);
    }

    public int getRewardPointsMax() {
        return this.config.getInt("event.reward-points-max", 100);
    }

    public List<String> getDefenseMobs() {
        return this.config.getStringList("mythicmobs.defense-mobs");
    }

    public List<String> getDefenseEliteMobs() {
        return this.config.getStringList("mythicmobs.defense-elite-mobs");
    }

    public int getBossSpawnThreshold() {
        return this.config.getInt("event.boss-spawn-threshold", 3);
    }

    public int getNpcRespawnDelay() {
        return this.config.getInt("event.npc-respawn-delay-seconds", 120);
    }

    public int getMurdererDurationSeconds() {
        return this.config.getInt("murderer.duration-seconds", 600);
    }

    public String getWeather() {
        return this.config.getString("world.weather", "CLEAR");
    }

    public boolean isAutoMorning() {
        return this.config.getBoolean("world.auto-morning", true);
    }

    public String getEventNpcType() {
        return this.config.getString("mythicmobs.event-npc-type", "EventNPC");
    }

    public List<String> getBossTypes() {
        List<String> bossTypes = this.config.getStringList("mythicmobs.boss-types");
        if (bossTypes.isEmpty()) {
            String oldBossType = this.config.getString("mythicmobs.boss-type", "SugarLord");
            bossTypes = Arrays.asList(oldBossType);
        }
        return bossTypes;
    }

    public String getDatabaseType() {
        return this.config.getString("database.type", "sqlite");
    }

    public String getSqliteFile() {
        return this.config.getString("database.sqlite.file", "data.db");
    }

    public boolean isDebugEnabled() {
        return this.config.getBoolean("debug.enabled", false);
    }

    public boolean isVerboseLogging() {
        return this.config.getBoolean("debug.verbose-logging", false);
    }

    public String getPrefix() {
        return this.config.getString("messages.prefix", "&6[CandyRush] &r");
    }

    public void reload() {
        this.plugin.reloadConfig();
    }
}

