/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.commands;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.PlayerData;
import com.candyrush.models.Team;
import com.candyrush.utils.LanguageManager;
import com.candyrush.utils.MessageUtils;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatsCommand
implements CommandExecutor {
    private final CandyRushPlugin plugin;
    private final LanguageManager lang;

    public StatsCommand(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.lang = plugin.getLanguageManager();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.lang.getMessage("player_only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            this.showPlayerStats(player, player);
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "top": {
                this.showTopPlayers(player);
                break;
            }
            case "teams": {
                this.showTeamStats(player);
                break;
            }
            case "help": {
                this.showHelp(player);
                break;
            }
            default: {
                this.showPlayerStats(player, player);
            }
        }
        return true;
    }

    private void showPlayerStats(Player viewer, Player target) {
        PlayerData data = this.plugin.getPlayerManager().getOrCreatePlayerData(target);
        viewer.sendMessage(MessageUtils.colorize("&a&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        viewer.sendMessage(MessageUtils.colorize("&e&l  " + target.getName() + " \u306e\u7d71\u8a08"));
        viewer.sendMessage(MessageUtils.colorize("&a&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        if (data.getTeamColor() != null) {
            viewer.sendMessage(MessageUtils.colorize("&e\u30c1\u30fc\u30e0: " + data.getTeamColor().getFormattedName()));
        } else {
            viewer.sendMessage(MessageUtils.colorize("&e\u30c1\u30fc\u30e0: &7\u672a\u5272\u308a\u5f53\u3066"));
        }
        viewer.sendMessage(MessageUtils.colorize("&e\u30dd\u30a4\u30f3\u30c8: &6" + MessageUtils.formatPoints(data.getPoints())));
        viewer.sendMessage(MessageUtils.colorize("&e\u30ad\u30eb: &c" + data.getKills()));
        viewer.sendMessage(MessageUtils.colorize("&e\u30c7\u30b9: &7" + data.getDeaths()));
        viewer.sendMessage(MessageUtils.colorize("&eK/D: &b" + String.format("%.2f", data.getKDRatio())));
        if (data.isMurdererActive()) {
            viewer.sendMessage(MessageUtils.colorize("&c&l\u72b6\u614b: Murderer"));
        }
        viewer.sendMessage(MessageUtils.colorize("&a&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
    }

    private void showTopPlayers(Player player) {
        List<PlayerData> topPlayers = this.plugin.getPlayerManager().getTopPlayers(10);
        player.sendMessage(MessageUtils.colorize("&6&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        player.sendMessage(MessageUtils.colorize("&e&l  \u30c8\u30c3\u30d7\u30d7\u30ec\u30a4\u30e4\u30fc TOP 10"));
        player.sendMessage(MessageUtils.colorize("&6&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        if (topPlayers.isEmpty()) {
            player.sendMessage(MessageUtils.colorize("&7\u30c7\u30fc\u30bf\u304c\u3042\u308a\u307e\u305b\u3093"));
        } else {
            int rank = 1;
            for (PlayerData data : topPlayers) {
                String rankColor = this.getRankColor(rank);
                String teamName = data.getTeamColor() != null ? data.getTeamColor().getFormattedName() : "&7\u672a\u6240\u5c5e";
                player.sendMessage(MessageUtils.colorize(rankColor + rank + ". &f" + data.getName() + " &7[" + teamName + "&7] &6" + MessageUtils.formatPoints(data.getPoints()) + "pt"));
                ++rank;
            }
        }
        player.sendMessage(MessageUtils.colorize("&6&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
    }

    private void showTeamStats(Player player) {
        List<Team> ranking = this.plugin.getTeamManager().getTeamRanking();
        player.sendMessage(MessageUtils.colorize("&b&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        player.sendMessage(MessageUtils.colorize("&e&l  \u30c1\u30fc\u30e0\u30e9\u30f3\u30ad\u30f3\u30b0"));
        player.sendMessage(MessageUtils.colorize("&b&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
        if (!this.plugin.getGameManager().isGameRunning()) {
            player.sendMessage(MessageUtils.colorize("&7\u30b2\u30fc\u30e0\u304c\u9032\u884c\u3057\u3066\u3044\u307e\u305b\u3093"));
        } else {
            int rank = 1;
            for (Team team : ranking) {
                String rankColor = this.getRankColor(rank);
                player.sendMessage(MessageUtils.colorize(rankColor + rank + ". " + team.getFormattedName() + " &7(" + team.getPlayerCount() + "\u4eba)"));
                player.sendMessage(MessageUtils.colorize("   &e\u30dd\u30a4\u30f3\u30c8: &6" + MessageUtils.formatPoints(team.getPoints()) + " &7| &e\u30ad\u30eb: &c" + team.getKills() + " &7| &e\u30c7\u30b9: &8" + team.getDeaths()));
                ++rank;
            }
        }
        player.sendMessage(MessageUtils.colorize("&b&l\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501"));
    }

    private void showHelp(Player player) {
        player.sendMessage(this.lang.getMessage("stats.help"));
        player.sendMessage(this.lang.getMessage("stats.help_usage"));
        player.sendMessage(this.lang.getMessage("stats.help_top"));
        player.sendMessage(this.lang.getMessage("stats.help_teams"));
    }

    private String getRankColor(int rank) {
        switch (rank) {
            case 1: {
                return "&6&l";
            }
            case 2: {
                return "&7&l";
            }
            case 3: {
                return "&c&l";
            }
        }
        return "&e";
    }
}

