/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.listeners;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.GameState;
import com.candyrush.utils.MessageUtils;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.ItemStack;

public class GoldItemConvertListener
implements Listener {
    private final CandyRushPlugin plugin;
    private static final int GOLD_NUGGET_POINTS = 1;
    private static final int GOLD_INGOT_POINTS = 9;

    public GoldItemConvertListener(CandyRushPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.getAction() != Action.RIGHT_CLICK_AIR && event.getAction() != Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (this.plugin.getGameManager().getCurrentState() != GameState.RUNNING) {
            return;
        }
        Material material = item.getType();
        int pointsPerItem = 0;
        if (material == Material.GOLD_NUGGET) {
            pointsPerItem = 1;
        } else if (material == Material.GOLD_INGOT) {
            pointsPerItem = 9;
        } else {
            return;
        }
        event.setCancelled(true);
        int amount = item.getAmount();
        int totalPoints = pointsPerItem * amount;
        this.plugin.getPlayerManager().addPoints(player.getUniqueId(), totalPoints);
        player.getInventory().setItemInMainHand(null);
        String itemName = material == Material.GOLD_NUGGET ? "\u91d1\u584a" : "\u91d1\u30a4\u30f3\u30b4\u30c3\u30c8";
        MessageUtils.sendMessage(player, "&6&l" + itemName + " x" + amount + " &7\u3092 &a&l+" + totalPoints + "pt &7\u306b\u5909\u63db\u3057\u307e\u3057\u305f\uff01");
        player.playSound(player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.2f);
        this.plugin.getLogger().info("Player " + player.getName() + " converted " + amount + " " + String.valueOf(material) + " to " + totalPoints + " points");
    }
}

