/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.managers;

import com.candyrush.CandyRushPlugin;
import com.candyrush.models.GameState;
import com.candyrush.models.PlayerData;
import com.candyrush.models.ShopItem;
import com.candyrush.utils.MessageUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionType;

public class ShopManager
implements Listener {
    private final CandyRushPlugin plugin;
    private final List<ShopItem> shopItems;
    private final Map<String, Inventory> openShops;
    private final Map<String, String> playerCurrentCategory;
    private FileConfiguration shopConfig;
    private File shopConfigFile;
    public static final Material SHOP_ITEM_MATERIAL = Material.EMERALD;
    public static final String SHOP_ITEM_NAME = "\u00a76\u00a7l\u2605 \u30b7\u30e7\u30c3\u30d7 \u2605";
    public static final int SHOP_ITEM_SLOT = 8;

    public ShopManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.shopItems = new ArrayList<ShopItem>();
        this.openShops = new HashMap<String, Inventory>();
        this.playerCurrentCategory = new HashMap<String, String>();
        this.loadShopConfig();
        this.loadShopItems();
    }

    private void loadShopConfig() {
        this.shopConfigFile = new File(this.plugin.getDataFolder(), "shop.yml");
        if (!this.shopConfigFile.exists()) {
            this.plugin.saveResource("shop.yml", false);
            this.plugin.getLogger().info("Created shop.yml file");
        }
        this.shopConfig = YamlConfiguration.loadConfiguration((File)this.shopConfigFile);
        this.plugin.getLogger().info("Loaded shop.yml configuration");
    }

    private void loadShopItems() {
        this.shopItems.clear();
        List itemsList = this.shopConfig.getList("items");
        if (itemsList == null || itemsList.isEmpty()) {
            this.plugin.getLogger().warning("No shop items configured in shop.yml");
            return;
        }
        for (Object obj : itemsList) {
            if (!(obj instanceof Map)) continue;
            Map itemMap = (Map)obj;
            try {
                String id = itemMap.getOrDefault("id", "unknown");
                String name = itemMap.getOrDefault("name", "Unknown Item");
                String materialStr = itemMap.getOrDefault("material", "STONE");
                int amount = itemMap.containsKey("amount") ? (Integer)itemMap.get("amount") : 1;
                int price = itemMap.containsKey("price") ? (Integer)itemMap.get("price") : 0;
                String potionTypeStr = (String)itemMap.get("potion-type");
                String category = itemMap.getOrDefault("category", "other");
                Material material = Material.getMaterial((String)materialStr);
                if (material == null) {
                    this.plugin.getLogger().warning("Invalid material for shop item: " + materialStr);
                    continue;
                }
                PotionType potionType = null;
                if (potionTypeStr != null) {
                    try {
                        potionType = PotionType.valueOf((String)potionTypeStr);
                    }
                    catch (IllegalArgumentException e) {
                        this.plugin.getLogger().warning("Invalid potion type for shop item: " + potionTypeStr);
                    }
                }
                ShopItem shopItem = new ShopItem(id, name, material, amount, price, potionType, category);
                this.shopItems.add(shopItem);
                this.plugin.getLogger().info("Loaded shop item: " + name + " (" + price + "pt) [category: " + category + "]");
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Failed to load shop item: " + String.valueOf(itemMap.get("id")) + " - " + e.getMessage());
                e.printStackTrace();
            }
        }
        this.plugin.getLogger().info("Loaded " + this.shopItems.size() + " shop items");
    }

    public void openShop(Player player) {
        this.openCategoryMenu(player);
    }

    private void openCategoryMenu(Player player) {
        Inventory menu = Bukkit.createInventory(null, (int)27, (String)"\u00a76\u00a7l\u30b7\u30e7\u30c3\u30d7 - \u30ab\u30c6\u30b4\u30ea\u9078\u629e");
        ItemStack weaponCategory = new ItemStack(Material.IRON_SWORD);
        ItemMeta weaponMeta = weaponCategory.getItemMeta();
        if (weaponMeta != null) {
            weaponMeta.setDisplayName("\u00a7f\u00a7l[\u6b66\u5668]");
            ArrayList<String> weaponLore = new ArrayList<String>();
            weaponLore.add("\u00a77\u5263\u3001\u5f13\u3001\u30af\u30ed\u30b9\u30dc\u30a6\u306a\u3069");
            weaponLore.add("");
            weaponLore.add("\u00a7e\u30af\u30ea\u30c3\u30af\u3057\u3066\u8868\u793a");
            weaponMeta.setLore(weaponLore);
            weaponCategory.setItemMeta(weaponMeta);
        }
        menu.setItem(10, weaponCategory);
        ItemStack armorCategory = new ItemStack(Material.IRON_CHESTPLATE);
        ItemMeta armorMeta = armorCategory.getItemMeta();
        if (armorMeta != null) {
            armorMeta.setDisplayName("\u00a7f\u00a7l[\u9632\u5177]");
            ArrayList<String> armorLore = new ArrayList<String>();
            armorLore.add("\u00a77\u30d8\u30eb\u30e1\u30c3\u30c8\u3001\u30c1\u30a7\u30b9\u30c8\u30d7\u30ec\u30fc\u30c8\u306a\u3069");
            armorLore.add("");
            armorLore.add("\u00a7e\u30af\u30ea\u30c3\u30af\u3057\u3066\u8868\u793a");
            armorMeta.setLore(armorLore);
            armorCategory.setItemMeta(armorMeta);
        }
        menu.setItem(11, armorCategory);
        ItemStack foodCategory = new ItemStack(Material.COOKED_BEEF);
        ItemMeta foodMeta = foodCategory.getItemMeta();
        if (foodMeta != null) {
            foodMeta.setDisplayName("\u00a7f\u00a7l[\u98df\u6599]");
            ArrayList<String> foodLore = new ArrayList<String>();
            foodLore.add("\u00a77\u30d1\u30f3\u3001\u8089\u3001\u91d1\u306e\u30ea\u30f3\u30b4\u306a\u3069");
            foodLore.add("");
            foodLore.add("\u00a7e\u30af\u30ea\u30c3\u30af\u3057\u3066\u8868\u793a");
            foodMeta.setLore(foodLore);
            foodCategory.setItemMeta(foodMeta);
        }
        menu.setItem(12, foodCategory);
        ItemStack buffCategory = new ItemStack(Material.POTION);
        ItemMeta buffMeta = buffCategory.getItemMeta();
        if (buffMeta != null) {
            buffMeta.setDisplayName("\u00a7f\u00a7l[\u30d0\u30d5\u30a2\u30a4\u30c6\u30e0]");
            ArrayList<String> buffLore = new ArrayList<String>();
            buffLore.add("\u00a77\u30dd\u30fc\u30b7\u30e7\u30f3\u3001\u30a8\u30f3\u30c1\u30e3\u30f3\u30c8\u672c\u306a\u3069");
            buffLore.add("");
            buffLore.add("\u00a7e\u30af\u30ea\u30c3\u30af\u3057\u3066\u8868\u793a");
            buffMeta.setLore(buffLore);
            buffCategory.setItemMeta(buffMeta);
        }
        menu.setItem(14, buffCategory);
        ItemStack toolCategory = new ItemStack(Material.ENDER_PEARL);
        ItemMeta toolMeta = toolCategory.getItemMeta();
        if (toolMeta != null) {
            toolMeta.setDisplayName("\u00a7f\u00a7l[\u4fbf\u5229\u30c4\u30fc\u30eb]");
            ArrayList<String> toolLore = new ArrayList<String>();
            toolLore.add("\u00a77\u77e2\u3001\u30a8\u30f3\u30c0\u30fc\u30d1\u30fc\u30eb\u3001\u30d6\u30ed\u30c3\u30af\u306a\u3069");
            toolLore.add("");
            toolLore.add("\u00a7e\u30af\u30ea\u30c3\u30af\u3057\u3066\u8868\u793a");
            toolMeta.setLore(toolLore);
            toolCategory.setItemMeta(toolMeta);
        }
        menu.setItem(15, toolCategory);
        PlayerData playerData = this.plugin.getPlayerManager().getOrCreatePlayerData(player);
        ItemStack pointsDisplay = new ItemStack(Material.GOLD_INGOT);
        ItemMeta pointsMeta = pointsDisplay.getItemMeta();
        if (pointsMeta != null) {
            pointsMeta.setDisplayName("\u00a76\u00a7l\u6240\u6301\u30dd\u30a4\u30f3\u30c8: " + playerData.getPoints() + "pt");
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77\u30dd\u30a4\u30f3\u30c8\u3067\u30a2\u30a4\u30c6\u30e0\u3092\u8cfc\u5165\u3067\u304d\u307e\u3059");
            pointsMeta.setLore(lore);
            pointsDisplay.setItemMeta(pointsMeta);
        }
        menu.setItem(26, pointsDisplay);
        this.playerCurrentCategory.remove(player.getName());
        player.openInventory(menu);
        this.openShops.put(player.getName(), menu);
        player.playSound(player.getLocation(), Sound.BLOCK_CHEST_OPEN, 1.0f, 1.0f);
    }

    private void openCategoryItems(Player player, String category) {
        ArrayList<ShopItem> categoryItems = new ArrayList<ShopItem>();
        for (ShopItem item : this.shopItems) {
            if (item.getCategory() == null || !item.getCategory().equals(category)) continue;
            categoryItems.add(item);
        }
        this.plugin.getLogger().info("Opening category '" + category + "' for " + player.getName() + " - Found " + categoryItems.size() + " items");
        for (ShopItem item : categoryItems) {
            this.plugin.getLogger().info("  - " + item.getName() + " (category: " + item.getCategory() + ")");
        }
        String categoryName = this.getCategoryDisplayName(category);
        Inventory itemsMenu = Bukkit.createInventory(null, (int)54, (String)("\u00a76\u00a7l" + categoryName));
        for (int i = 0; i < categoryItems.size() && i < 45; ++i) {
            itemsMenu.setItem(i, ((ShopItem)categoryItems.get(i)).createItemStack());
        }
        ItemStack backButton = new ItemStack(Material.ARROW);
        ItemMeta backMeta = backButton.getItemMeta();
        if (backMeta != null) {
            backMeta.setDisplayName("\u00a7e\u00a7l\u2190 \u30ab\u30c6\u30b4\u30ea\u9078\u629e\u306b\u623b\u308b");
            backButton.setItemMeta(backMeta);
        }
        itemsMenu.setItem(49, backButton);
        PlayerData playerData = this.plugin.getPlayerManager().getOrCreatePlayerData(player);
        ItemStack pointsDisplay = new ItemStack(Material.GOLD_INGOT);
        ItemMeta pointsMeta = pointsDisplay.getItemMeta();
        if (pointsMeta != null) {
            pointsMeta.setDisplayName("\u00a76\u00a7l\u6240\u6301\u30dd\u30a4\u30f3\u30c8: " + playerData.getPoints() + "pt");
            pointsDisplay.setItemMeta(pointsMeta);
        }
        itemsMenu.setItem(53, pointsDisplay);
        this.playerCurrentCategory.put(player.getName(), category);
        player.openInventory(itemsMenu);
        this.openShops.put(player.getName(), itemsMenu);
        player.playSound(player.getLocation(), Sound.UI_BUTTON_CLICK, 1.0f, 1.0f);
    }

    private String getCategoryDisplayName(String category) {
        switch (category) {
            case "weapon": {
                return "\u6b66\u5668";
            }
            case "armor": {
                return "\u9632\u5177";
            }
            case "food": {
                return "\u98df\u6599";
            }
            case "buff": {
                return "\u30d0\u30d5\u30a2\u30a4\u30c6\u30e0";
            }
            case "tool": {
                return "\u4fbf\u5229\u30c4\u30fc\u30eb";
            }
        }
        return "\u305d\u306e\u4ed6";
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Inventory clickedInventory = event.getClickedInventory();
        this.plugin.getLogger().info("Inventory click detected: player=" + player.getName() + ", hasOpenShop=" + this.openShops.containsKey(player.getName()));
        if (!this.openShops.containsKey(player.getName())) {
            return;
        }
        Inventory shopInventory = this.openShops.get(player.getName());
        if (clickedInventory == null || !clickedInventory.equals((Object)shopInventory)) {
            this.plugin.getLogger().info("Click not in shop inventory - clickedInv=" + String.valueOf(clickedInventory != null ? clickedInventory.getType() : "null"));
            return;
        }
        event.setCancelled(true);
        ItemStack clickedItem = event.getCurrentItem();
        if (clickedItem == null || clickedItem.getType() == Material.AIR) {
            return;
        }
        int slot = event.getSlot();
        String currentCategory = this.playerCurrentCategory.get(player.getName());
        this.plugin.getLogger().info("Shop click: player=" + player.getName() + ", slot=" + slot + ", category=" + currentCategory + ", item=" + String.valueOf(clickedItem.getType()));
        if (currentCategory == null) {
            if (slot == 26) {
                return;
            }
            switch (slot) {
                case 10: {
                    this.plugin.getLogger().info("Opening weapon category");
                    this.openCategoryItems(player, "weapon");
                    break;
                }
                case 11: {
                    this.plugin.getLogger().info("Opening armor category");
                    this.openCategoryItems(player, "armor");
                    break;
                }
                case 12: {
                    this.plugin.getLogger().info("Opening food category");
                    this.openCategoryItems(player, "food");
                    break;
                }
                case 14: {
                    this.plugin.getLogger().info("Opening buff category");
                    this.openCategoryItems(player, "buff");
                    break;
                }
                case 15: {
                    this.plugin.getLogger().info("Opening tool category");
                    this.openCategoryItems(player, "tool");
                }
            }
            return;
        }
        if (slot == 53) {
            return;
        }
        if (slot == 49) {
            this.plugin.getLogger().info("Back button clicked - returning to category menu");
            this.openCategoryMenu(player);
            return;
        }
        if (slot < 45) {
            ArrayList<ShopItem> categoryItems = new ArrayList<ShopItem>();
            for (ShopItem item : this.shopItems) {
                if (item.getCategory() == null || !item.getCategory().equals(currentCategory)) continue;
                categoryItems.add(item);
            }
            if (slot < categoryItems.size()) {
                ShopItem shopItem = (ShopItem)categoryItems.get(slot);
                this.purchaseItem(player, shopItem);
            }
        }
    }

    private void purchaseItem(Player player, ShopItem shopItem) {
        PlayerData playerData = this.plugin.getPlayerManager().getOrCreatePlayerData(player);
        if (playerData.getPoints() < shopItem.getPrice()) {
            MessageUtils.sendMessage(player, "&c\u30dd\u30a4\u30f3\u30c8\u304c\u4e0d\u8db3\u3057\u3066\u3044\u307e\u3059\uff01 (&6\u5fc5\u8981: " + shopItem.getPrice() + "pt&c)");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        if (player.getInventory().firstEmpty() == -1) {
            MessageUtils.sendMessage(player, "&c\u30a4\u30f3\u30d9\u30f3\u30c8\u30ea\u304c\u3044\u3063\u3071\u3044\u3067\u3059\uff01");
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            return;
        }
        playerData.addPoints(-shopItem.getPrice());
        this.plugin.getPlayerManager().savePlayerData(playerData);
        player.getInventory().addItem(new ItemStack[]{shopItem.createPurchasedItem()});
        MessageUtils.sendMessage(player, "&a&l\u8cfc\u5165\u6210\u529f\uff01 &7" + shopItem.getName() + " &ax" + shopItem.getAmount());
        MessageUtils.sendMessage(player, "&7\u6b8b\u308a\u30dd\u30a4\u30f3\u30c8: &6" + playerData.getPoints() + "pt");
        player.playSound(player.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
        String currentCategory = this.playerCurrentCategory.get(player.getName());
        if (currentCategory != null) {
            this.openCategoryItems(player, currentCategory);
        } else {
            this.openCategoryMenu(player);
        }
        this.plugin.getLogger().info("Player " + player.getName() + " purchased " + shopItem.getName() + " for " + shopItem.getPrice() + "pt");
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (event.getPlayer() instanceof Player) {
            Player player = (Player)event.getPlayer();
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                if (player.getOpenInventory().getTopInventory().equals((Object)event.getInventory())) {
                    this.openShops.remove(player.getName());
                    this.playerCurrentCategory.remove(player.getName());
                    this.plugin.getLogger().info("Cleared shop data for " + player.getName());
                }
            }, 1L);
        }
    }

    @EventHandler
    public void onShopItemInteract(PlayerInteractEvent event) {
        Player player = event.getPlayer();
        ItemStack item = event.getItem();
        if (event.getAction() != Action.RIGHT_CLICK_AIR) {
            return;
        }
        if (!ShopManager.isShopItem(item)) {
            return;
        }
        event.setCancelled(true);
        if (this.plugin.getGameManager().getCurrentState() != GameState.RUNNING) {
            MessageUtils.sendMessage(player, "&c\u30b2\u30fc\u30e0\u4e2d\u306e\u307f\u30b7\u30e7\u30c3\u30d7\u3092\u5229\u7528\u3067\u304d\u307e\u3059\uff01");
            return;
        }
        this.openShop(player);
    }

    @EventHandler
    public void onShopItemDrop(PlayerDropItemEvent event) {
        ItemStack item = event.getItemDrop().getItemStack();
        if (ShopManager.isShopItem(item)) {
            event.setCancelled(true);
            MessageUtils.sendMessage(event.getPlayer(), "&c\u30b7\u30e7\u30c3\u30d7\u30a2\u30a4\u30c6\u30e0\u306f\u6368\u3066\u3089\u308c\u307e\u305b\u3093\uff01");
        }
    }

    @EventHandler
    public void onShopItemMove(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        ItemStack item = event.getCurrentItem();
        if (ShopManager.isShopItem(item) && !this.openShops.containsKey(event.getWhoClicked().getName())) {
            event.setCancelled(true);
        }
    }

    public static ItemStack createShopItem() {
        ItemStack shopItem = new ItemStack(SHOP_ITEM_MATERIAL);
        ItemMeta meta = shopItem.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(SHOP_ITEM_NAME);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("\u00a77\u53f3\u30af\u30ea\u30c3\u30af\u3067\u30b7\u30e7\u30c3\u30d7\u3092\u958b\u304f");
            lore.add("\u00a78\u3053\u306e\u30a2\u30a4\u30c6\u30e0\u306f\u6368\u3066\u3089\u308c\u307e\u305b\u3093");
            meta.setLore(lore);
            shopItem.setItemMeta(meta);
        }
        return shopItem;
    }

    public static boolean isShopItem(ItemStack item) {
        if (item == null || item.getType() != SHOP_ITEM_MATERIAL) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (meta == null || !meta.hasDisplayName()) {
            return false;
        }
        return meta.getDisplayName().equals(SHOP_ITEM_NAME);
    }

    public void giveShopItem(Player player) {
        player.getInventory().setItem(8, ShopManager.createShopItem());
    }

    public void reload() {
        this.loadShopConfig();
        this.loadShopItems();
    }
}

