/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.models;

import org.bukkit.Material;

public enum ChestType {
    CHEST(Material.CHEST, false),
    LARGE_CHEST(Material.CHEST, false),
    BARREL(Material.BARREL, false),
    FURNACE(Material.FURNACE, false),
    BLAST_FURNACE(Material.BLAST_FURNACE, false),
    SMOKER(Material.SMOKER, false),
    BREWING_STAND(Material.BREWING_STAND, false),
    HOPPER(Material.HOPPER, false),
    DROPPER(Material.DROPPER, false),
    DISPENSER(Material.DISPENSER, false),
    TRAPPED_CHEST(Material.TRAPPED_CHEST, true);

    private final Material material;
    private final boolean isTrapped;

    private ChestType(Material material, boolean isTrapped) {
        this.material = material;
        this.isTrapped = isTrapped;
    }

    public Material getMaterial() {
        return this.material;
    }

    public boolean isTrapped() {
        return this.isTrapped;
    }

    public boolean isContainer() {
        return this.material.toString().contains("CHEST") || this.material.toString().contains("BARREL") || this.material.toString().contains("FURNACE") || this.material.toString().contains("SMOKER") || this.material.toString().contains("BREWING_STAND") || this.material.toString().contains("HOPPER") || this.material.toString().contains("DROPPER") || this.material.toString().contains("DISPENSER");
    }

    public static ChestType random() {
        double rand = Math.random() * 100.0;
        if (rand < 70.0) {
            return CHEST;
        }
        if (rand < 73.0) {
            return TRAPPED_CHEST;
        }
        ChestType[] others = new ChestType[]{LARGE_CHEST, BARREL, FURNACE, BLAST_FURNACE, SMOKER, BREWING_STAND, HOPPER, DROPPER, DISPENSER};
        return others[(int)(Math.random() * (double)others.length)];
    }

    public static ChestType randomNormal() {
        ChestType type;
        while ((type = ChestType.random()).isTrapped()) {
        }
        return type;
    }
}

