/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.models;

import com.candyrush.models.TeamColor;
import java.util.UUID;

public class PlayerData {
    private final UUID uuid;
    private String name;
    private TeamColor teamColor;
    private int points;
    private int kills;
    private int deaths;
    private boolean isMurderer;
    private long murdererUntil;
    private long lastSeen;
    private final long createdAt;
    private long updatedAt;

    public PlayerData(UUID uuid, String name) {
        long now;
        this.uuid = uuid;
        this.name = name;
        this.teamColor = null;
        this.points = 0;
        this.kills = 0;
        this.deaths = 0;
        this.isMurderer = false;
        this.murdererUntil = 0L;
        this.lastSeen = now = System.currentTimeMillis() / 1000L;
        this.createdAt = now;
        this.updatedAt = now;
    }

    public PlayerData(UUID uuid, String name, TeamColor teamColor, int points, int kills, int deaths, boolean isMurderer, long murdererUntil, long lastSeen, long createdAt, long updatedAt) {
        this.uuid = uuid;
        this.name = name;
        this.teamColor = teamColor;
        this.points = points;
        this.kills = kills;
        this.deaths = deaths;
        this.isMurderer = isMurderer;
        this.murdererUntil = murdererUntil;
        this.lastSeen = lastSeen;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public TeamColor getTeamColor() {
        return this.teamColor;
    }

    public int getPoints() {
        return this.points;
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        return this.deaths;
    }

    public boolean isMurderer() {
        return this.isMurderer;
    }

    public long getMurdererUntil() {
        return this.murdererUntil;
    }

    public long getLastSeen() {
        return this.lastSeen;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public void setName(String name) {
        this.name = name;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setTeamColor(TeamColor teamColor) {
        this.teamColor = teamColor;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setPoints(int points) {
        this.points = points;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void addPoints(int amount) {
        this.points += amount;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setKills(int kills) {
        this.kills = kills;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void incrementKills() {
        ++this.kills;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setDeaths(int deaths) {
        this.deaths = deaths;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void incrementDeaths() {
        ++this.deaths;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setMurderer(boolean isMurderer) {
        this.isMurderer = isMurderer;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setMurdererUntil(long murdererUntil) {
        this.murdererUntil = murdererUntil;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void setLastSeen(long lastSeen) {
        this.lastSeen = lastSeen;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void updateLastSeen() {
        this.updatedAt = this.lastSeen = System.currentTimeMillis() / 1000L;
    }

    public boolean isMurdererActive() {
        if (!this.isMurderer) {
            return false;
        }
        long now = System.currentTimeMillis() / 1000L;
        return now < this.murdererUntil;
    }

    public void clearMurderer() {
        this.isMurderer = false;
        this.murdererUntil = 0L;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public void resetForNewGame() {
        this.teamColor = null;
        this.points = 0;
        this.updatedAt = System.currentTimeMillis() / 1000L;
    }

    public double getKDRatio() {
        if (this.deaths == 0) {
            return this.kills;
        }
        return (double)this.kills / (double)this.deaths;
    }

    public String toString() {
        return "PlayerData{uuid=" + String.valueOf(this.uuid) + ", name='" + this.name + "', teamColor=" + String.valueOf((Object)this.teamColor) + ", points=" + this.points + ", kills=" + this.kills + ", deaths=" + this.deaths + ", isMurderer=" + this.isMurderer + "}";
    }
}

