/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.storage;

import com.candyrush.CandyRushPlugin;
import com.candyrush.libs.hikari.HikariConfig;
import com.candyrush.libs.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;

public class DatabaseInitializer {
    private final CandyRushPlugin plugin;
    private HikariDataSource dataSource;

    public DatabaseInitializer(CandyRushPlugin plugin) {
        this.plugin = plugin;
    }

    public void initialize() throws SQLException {
        File dataFolder = this.plugin.getDataFolder();
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        HikariConfig config = new HikariConfig();
        String dbPath = new File(dataFolder, this.plugin.getConfigManager().getSqliteFile()).getAbsolutePath();
        config.setJdbcUrl("jdbc:sqlite:" + dbPath);
        config.setDriverClassName("org.sqlite.JDBC");
        config.setMaximumPoolSize(10);
        config.setMinimumIdle(2);
        config.setConnectionTimeout(30000L);
        config.setIdleTimeout(600000L);
        config.setMaxLifetime(1800000L);
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        this.dataSource = new HikariDataSource(config);
        this.createTables();
        this.plugin.getLogger().info("Database initialized successfully at: " + dbPath);
    }

    private void createTables() throws SQLException {
        try (Connection conn = this.dataSource.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS players (    uuid TEXT PRIMARY KEY,    name TEXT NOT NULL,    team_color TEXT,    points INTEGER DEFAULT 0,    kills INTEGER DEFAULT 0,    deaths INTEGER DEFAULT 0,    is_murderer INTEGER DEFAULT 0,    murderer_until INTEGER,    last_seen INTEGER,    created_at INTEGER NOT NULL,    updated_at INTEGER NOT NULL)");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS game_rounds (    id INTEGER PRIMARY KEY AUTOINCREMENT,    started_at INTEGER NOT NULL,    ended_at INTEGER,    winner_team TEXT,    total_players INTEGER DEFAULT 0,    duration_seconds INTEGER,    created_at INTEGER NOT NULL)");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS team_scores (    id INTEGER PRIMARY KEY AUTOINCREMENT,    round_id INTEGER NOT NULL,    team_color TEXT NOT NULL,    final_points INTEGER DEFAULT 0,    total_kills INTEGER DEFAULT 0,    total_deaths INTEGER DEFAULT 0,    players_count INTEGER DEFAULT 0,    created_at INTEGER NOT NULL,    FOREIGN KEY (round_id) REFERENCES game_rounds(id) ON DELETE CASCADE)");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS player_stats (    id INTEGER PRIMARY KEY AUTOINCREMENT,    round_id INTEGER NOT NULL,    player_uuid TEXT NOT NULL,    team_color TEXT NOT NULL,    points_earned INTEGER DEFAULT 0,    kills INTEGER DEFAULT 0,    deaths INTEGER DEFAULT 0,    chests_opened INTEGER DEFAULT 0,    food_deposited INTEGER DEFAULT 0,    became_murderer INTEGER DEFAULT 0,    created_at INTEGER NOT NULL,    FOREIGN KEY (round_id) REFERENCES game_rounds(id) ON DELETE CASCADE,    FOREIGN KEY (player_uuid) REFERENCES players(uuid) ON DELETE CASCADE)");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS treasure_chests (    id INTEGER PRIMARY KEY AUTOINCREMENT,    round_id INTEGER NOT NULL,    world TEXT NOT NULL,    x INTEGER NOT NULL,    y INTEGER NOT NULL,    z INTEGER NOT NULL,    chest_type TEXT NOT NULL,    spawned_at INTEGER NOT NULL,    FOREIGN KEY (round_id) REFERENCES game_rounds(id) ON DELETE CASCADE)");
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS event_npcs (    id INTEGER PRIMARY KEY AUTOINCREMENT,    round_id INTEGER NOT NULL,    entity_uuid TEXT,    world TEXT NOT NULL,    x REAL NOT NULL,    y REAL NOT NULL,    z REAL NOT NULL,    yaw REAL NOT NULL,    pitch REAL NOT NULL,    npc_type TEXT NOT NULL,    spawned_at INTEGER NOT NULL,    FOREIGN KEY (round_id) REFERENCES game_rounds(id) ON DELETE CASCADE)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_players_team ON players(team_color)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_players_points ON players(points DESC)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_game_rounds_started ON game_rounds(started_at DESC)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_team_scores_round ON team_scores(round_id)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_player_stats_round ON player_stats(round_id)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_player_stats_uuid ON player_stats(player_uuid)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_treasure_chests_round ON treasure_chests(round_id)");
            stmt.executeUpdate("CREATE INDEX IF NOT EXISTS idx_event_npcs_round ON event_npcs(round_id)");
            this.plugin.getLogger().info("Database tables created/verified successfully");
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.dataSource == null || this.dataSource.isClosed()) {
            throw new SQLException("Database connection pool is not initialized");
        }
        return this.dataSource.getConnection();
    }

    public void close() {
        if (this.dataSource != null && !this.dataSource.isClosed()) {
            this.dataSource.close();
            this.plugin.getLogger().info("Database connection pool closed");
        }
    }

    public boolean isInitialized() {
        return this.dataSource != null && !this.dataSource.isClosed();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean healthCheck() {
        try (Connection conn = this.getConnection();){
            boolean bl;
            block14: {
                Statement stmt = conn.createStatement();
                try {
                    stmt.executeQuery("SELECT 1");
                    bl = true;
                    if (stmt == null) break block14;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Database health check failed", e);
            return false;
        }
    }
}

