/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.utils;

import com.candyrush.CandyRushPlugin;
import com.candyrush.utils.MessageUtils;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class LanguageManager {
    private final CandyRushPlugin plugin;
    private FileConfiguration messages;
    private String currentLanguage;

    public LanguageManager(CandyRushPlugin plugin) {
        this.plugin = plugin;
        this.currentLanguage = plugin.getConfigManager().getLanguage();
        this.loadMessages();
    }

    private void loadMessages() {
        String languageFile = "messages_" + this.currentLanguage + ".yml";
        File customFile = new File(this.plugin.getDataFolder(), languageFile);
        if (customFile.exists()) {
            this.messages = YamlConfiguration.loadConfiguration((File)customFile);
            this.plugin.getLogger().info("Loaded custom language file: " + languageFile);
        } else {
            InputStream defaultStream = this.plugin.getResource(languageFile);
            if (defaultStream != null) {
                this.messages = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream, StandardCharsets.UTF_8));
                this.plugin.getLogger().info("Loaded language file from jar: " + languageFile);
            } else {
                this.plugin.getLogger().warning("Language file not found: " + languageFile + ", falling back to English");
                InputStream fallbackStream = this.plugin.getResource("messages_en.yml");
                if (fallbackStream != null) {
                    this.messages = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(fallbackStream, StandardCharsets.UTF_8));
                } else {
                    this.plugin.getLogger().severe("Could not load any language file!");
                    this.messages = new YamlConfiguration();
                }
            }
        }
    }

    public String getMessage(String key) {
        String message = this.messages.getString(key);
        if (message == null) {
            this.plugin.getLogger().warning("Missing translation key: " + key);
            return "&c[Missing: " + key + "]";
        }
        return MessageUtils.colorize(message);
    }

    public String getMessage(String key, Map<String, String> placeholders) {
        String message = this.getMessage(key);
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            message = message.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return message;
    }

    public String getMessage(String key, String placeholder, String value) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(placeholder, value);
        return this.getMessage(key, map);
    }

    public String getMessageWithPrefix(String key) {
        return this.getMessage("prefix") + this.getMessage(key);
    }

    public String getMessageWithPrefix(String key, Map<String, String> placeholders) {
        return this.getMessage("prefix") + this.getMessage(key, placeholders);
    }

    public void setLanguage(String language) {
        this.currentLanguage = language;
        this.loadMessages();
        this.plugin.getLogger().info("Language changed to: " + language);
    }

    public String getCurrentLanguage() {
        return this.currentLanguage;
    }

    public void reload() {
        this.currentLanguage = this.plugin.getConfigManager().getLanguage();
        this.loadMessages();
    }
}

