/*
 * Decompiled with CFR 0.152.
 */
package com.candyrush.utils;

import java.time.Duration;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.title.Title;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class MessageUtils {
    public static String colorize(String message) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public static Component toComponent(String message) {
        return Component.text((String)MessageUtils.colorize(message));
    }

    public static void sendMessage(Player player, String message) {
        player.sendMessage(MessageUtils.colorize(message));
    }

    public static void sendTitle(Player player, String title, String subtitle) {
        Title titleObject = Title.title((Component)MessageUtils.toComponent(title), (Component)MessageUtils.toComponent(subtitle), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(500L), (Duration)Duration.ofSeconds(3L), (Duration)Duration.ofMillis(500L)));
        player.showTitle(titleObject);
    }

    public static void sendTitle(Player player, String title, String subtitle, int fadeIn, int stay, int fadeOut) {
        Title titleObject = Title.title((Component)MessageUtils.toComponent(title), (Component)MessageUtils.toComponent(subtitle), (Title.Times)Title.Times.times((Duration)Duration.ofMillis(fadeIn * 50), (Duration)Duration.ofMillis(stay * 50), (Duration)Duration.ofMillis(fadeOut * 50)));
        player.showTitle(titleObject);
    }

    public static void sendActionBar(Player player, String message) {
        player.sendActionBar(MessageUtils.toComponent(message));
    }

    public static String formatCountdown(int seconds) {
        if (seconds <= 3) {
            return "&c&l" + seconds;
        }
        if (seconds <= 5) {
            return "&e&l" + seconds;
        }
        return "&a" + seconds;
    }

    public static String formatTime(int seconds) {
        int minutes = seconds / 60;
        int secs = seconds % 60;
        return String.format("%02d:%02d", minutes, secs);
    }

    public static String formatPoints(int points) {
        return String.format("%,d", points);
    }

    public static Component success(String message) {
        return Component.text((String)message).color((TextColor)NamedTextColor.GREEN);
    }

    public static Component error(String message) {
        return Component.text((String)message).color((TextColor)NamedTextColor.RED);
    }

    public static Component warning(String message) {
        return Component.text((String)message).color((TextColor)NamedTextColor.YELLOW);
    }

    public static Component highlight(String message) {
        return ((TextComponent)Component.text((String)message).color((TextColor)NamedTextColor.GOLD)).decoration(TextDecoration.BOLD, true);
    }
}

