package com.mythicmetals;

import com.mythicmetals.ability.Abilities;
import com.mythicmetals.armor.*;
import com.mythicmetals.block.BanglumNukeHandler;
import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.block.entity.RegisterBlockEntityTypes;
import com.mythicmetals.command.MythicCommands;
import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.conditions.MythicResourceConditions;
import com.mythicmetals.config.MythicMetalsConfig;
import com.mythicmetals.data.MythicOreFeatures;
import com.mythicmetals.effects.MythicStatusEffects;
import com.mythicmetals.entity.*;
import com.mythicmetals.item.MythicItems;
import com.mythicmetals.item.MythicPotions;
import com.mythicmetals.item.tools.MythicTools;
import com.mythicmetals.misc.*;
import com.mythicmetals.recipe.MythicRecipeSerializers;
import com.mythicmetals.registry.*;
import io.wispforest.owo.itemgroup.Icon;
import io.wispforest.owo.itemgroup.OwoItemGroup;
import io.wispforest.owo.itemgroup.gui.ItemGroupButton;
import io.wispforest.owo.registration.reflect.FieldRegistrationHandler;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.object.builder.v1.trade.TradeOfferHelper;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1688;
import net.minecraft.class_2315;
import net.minecraft.class_2965;
import net.minecraft.class_3852;
import net.minecraft.class_3853;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistry;
import org.ladysnake.cca.api.v3.entity.*;

public class MythicMetals implements ModInitializer, EntityComponentInitializer {
    public static Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "mythicmetals";
    public static final int CONFIG_VERSION = 13;

    public static final class_1688.class_1689 BANGLUM_TNT = Enum.valueOf(class_1688.class_1689.class, "BANGLUM_TNT");
    public static final class_1688.class_1689 PALLADIUM_MINECART = Enum.valueOf(class_1688.class_1689.class, "PALLADIUM_MINECART");

    public static MythicMetalsConfig CONFIG = MythicMetalsConfig.createAndLoad();

    public static final OwoItemGroup TABBED_GROUP = OwoItemGroup.builder(RegistryHelper.id("main"), () -> Icon.of(MythicItems.STORMYX.getIngot()))
        .initializer(group -> {
            group.addTab(Icon.of(MythicItems.ADAMANTITE.getIngot()), "items", class_6862.method_40092(class_7924.field_41197, RegistryHelper.id("item_tab")), false);
            group.addTab(Icon.of(MythicBlocks.ADAMANTITE.getStorageBlock()), "blocks", class_6862.method_40092(class_7924.field_41197, RegistryHelper.id("blocks")), false);
            group.addTab(Icon.of(MythicTools.ADAMANTITE.getPickaxe()), "tools", class_6862.method_40092(class_7924.field_41197, RegistryHelper.id("tool_tab")), false);
            group.addTab(Icon.of(MythicArmor.ADAMANTITE.getChestplate()), "armor", class_6862.method_40092(class_7924.field_41197, RegistryHelper.id("armor_tab")), false);
            group.addButton(ItemGroupButton.github(group, "https://github.com/Noaaan/MythicMetals/issues"));
            group.addButton(ItemGroupButton.curseforge(group, "https://www.curseforge.com/minecraft/mc-mods/mythicmetals"));
            group.addButton(ItemGroupButton.modrinth(group, "https://modrinth.com/mod/mythicmetals"));
            group.addButton(ItemGroupButton.discord(group, "https://discord.gg/69cKvQWScC"));
        })
        .build();

    public static final ComponentKey<CarmotShield> CARMOT_SHIELD = ComponentRegistry.getOrCreate(RegistryHelper.id("carmot_shield"), CarmotShield.class);
    public static final ComponentKey<CombustionCooldown> COMBUSTION_COOLDOWN = ComponentRegistry.getOrCreate(RegistryHelper.id("combustion_cooldown"), CombustionCooldown.class);

    @Override
    public void onInitialize() {
        FieldRegistrationHandler.register(RegisterSounds.class, MOD_ID, false);
        FieldRegistrationHandler.processSimple(MythicItems.class, false);
        FieldRegistrationHandler.register(MythicItems.Mats.class, MOD_ID, false);
        FieldRegistrationHandler.register(MythicItems.Templates.class, MOD_ID, false);
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            FieldRegistrationHandler.register(MythicItems.ParticleSticks.class, MOD_ID, false);
        }
        FieldRegistrationHandler.processSimple(MythicItems.Copper.class, false);
        FieldRegistrationHandler.register(MythicArmorMaterials.class, MOD_ID, false);
        FieldRegistrationHandler.processSimple(MythicTools.class, true);
        FieldRegistrationHandler.processSimple(MythicArmor.class, false);
        FieldRegistrationHandler.register(RegisterBlockEntityTypes.class, MOD_ID, false);
        MythicParticleSystem.init();
        MythicBlocks.init();
        MythicDataComponents.init();
        MythicPotions.init();
        BanglumNukeHandler.init();
        MythicOreFeatures.init();
        MythicCommands.init();
        MythicCommands.registerCommands();
        Abilities.init();
        RegisterPointOfInterests.init();
        MythicEntityAttributes.init();
        MythicEntities.init();
        TABBED_GROUP.initialize();
        FuelRegistry.INSTANCE.add(MythicItems.Mats.MORKITE, 1200);
        FuelRegistry.INSTANCE.add(MythicBlocks.MORKITE.getStorageBlock(), 12800);
        MythicResourceConditions.init();
        RegisterLootConditions.init();
        MythicStatusEffects.init();
        MythicRecipeSerializers.init();
        FieldRegistrationHandler.processSimple(RegisterCriteria.class, false);
        BlockBreaker.initHammerTime();
        MythicLootOps.init();
        TradeOfferHelper.registerVillagerOffers(class_3852.field_17055, 5, factories -> {
            factories.add(new class_3853.class_4165(MythicItems.Templates.AEGIS_SMITHING_TEMPLATE, 48, 1, 2, 30));
        });
        registerDispenserBehaviour();

        if (CONFIG.configVersion() < CONFIG_VERSION) {
            for (int i = 0; i < 5; i++) {
                LOGGER.warn("[Mythic Metals] Your config is outdated. Please update it manually in the file, or delete it so it can be re-generated.");
            }
        }

        if (FabricLoader.getInstance().isModLoaded("harvest_scythes")) {
            LOGGER.info("[Mythic Metals] I see HarvestScythes. I'll take care of DH so you don't have to");
        }
        if (FabricLoader.getInstance().isModLoaded("enhancedcraft")) {
            LOGGER.info("[Mythic Metals] Oh EnhancedCraft? If you ever see Spxctre tell him I said hi!");
        }
        if (FabricLoader.getInstance().isModLoaded("origins")) {
            LOGGER.info("[Mythic Metals] Have fun using Origins!");
        }
        if (FabricLoader.getInstance().isModLoaded("spectrum")) {
            LOGGER.info("[Mythic Metals] Spectrum is loaded! Good luck on finding all of its secrets...");
        }
        if (FabricLoader.getInstance().isModLoaded("jello")) {
            LOGGER.info("[Mythic Metals] Is that Jello? Here comes the colors, weeeeeee!");
        }
        if (FabricLoader.getInstance().isModLoaded("terralith")) {
            LOGGER.info("[Mythic Metals] Terralith detected. Many ores can spawn in unexpected ways due to the new overworld. Modpack devs, take note of this");
        }
        if (FabricLoader.getInstance().isModLoaded("ftb-chunks-fabric") || FabricLoader.getInstance().isModLoaded("ftb-chunks-neoforge")) {
            if (!FabricLoader.getInstance().isModLoaded("ftb-xmod-compat-fabric")) {
                for (int i = 0; i < 3; i++) {
                    LOGGER.error("[Mythic Metals] FTB Chunks is loaded but FTB XMod Compat Fabric addon is not. This means claim protection will not work for some items!");
                }
            }
        }
        LOGGER.info("[Mythic Metals] Mythic Metals is now initialized.");
    }

    private void registerDispenserBehaviour() {
        class_2315.method_10009(() -> MythicTools.STAR_PLATINUM_ARROW, new class_2965(MythicTools.STAR_PLATINUM_ARROW));
        class_2315.method_10009(() -> MythicTools.RUNITE_ARROW, new class_2965(MythicTools.RUNITE_ARROW));
        class_2315.method_10009(() -> MythicTools.TIPPED_RUNITE_ARROW, new class_2965(MythicTools.TIPPED_RUNITE_ARROW));
    }


    @Override
    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerFor(class_1309.class, COMBUSTION_COOLDOWN, CombustionCooldown::new);
        registry.registerForPlayers(CARMOT_SHIELD, CarmotShield::new, RespawnCopyStrategy.INVENTORY);
    }

}
