package com.mythicmetals.ability;

import I;
import com.mythicmetals.armor.ArmorSet;
import com.mythicmetals.item.tools.ToolSet;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.text.*;
import java.util.*;

/**
 * An ability is a container of items which have specific behaviour.
 * These are put into a set, and queried for later when needed.
 * Most of these are implemented in {@link com.mythicmetals.mixin.EnchantmentHelperMixin EnchantmentHelperMixin}
 * <br>
 * Other than that, this class also handles tooltips for the items.
 */
public class Ability {

    private final String tooltip;
    private final int level;
    private final Set<class_1792> items;
    private boolean showLevel = true;

    public Ability(String translationKey, int level) {
        this.tooltip = translationKey;
        this.level = level;
        this.items = new HashSet<>();
    }

    public Ability(String translationKey, int level, boolean showLevel) {
        this.tooltip = translationKey;
        this.level = level;
        this.items = new HashSet<>();
        this.showLevel = showLevel;
    }

    public int getLevel() {
        return level;
    }

    public Set<class_1792> getItems() {
        return items;
    }

    public void addItem(class_1792 item, class_2583 style) {
        items.add(item);
        if (FabricLoader.getInstance().getEnvironmentType().equals(EnvType.CLIENT))
            addTooltip(item, style);

    }

    public void addArmorSet(ArmorSet armorSet, class_2583 style) {
        items.add(armorSet.getHelmet());
        items.add(armorSet.getChestplate());
        items.add(armorSet.getLeggings());
        items.add(armorSet.getBoots());
        if (FabricLoader.getInstance().getEnvironmentType().equals(EnvType.CLIENT)) {
            addTooltip(armorSet.getHelmet(), style);
            addTooltip(armorSet.getChestplate(), style);
            addTooltip(armorSet.getLeggings(), style);
            addTooltip(armorSet.getBoots(), style);
        }

    }

    public void addToolSet(ToolSet toolSet, class_2583 style) {
        items.add(toolSet.getSword());
        items.add(toolSet.getAxe());
        items.add(toolSet.getHoe());
        items.add(toolSet.getPickaxe());
        items.add(toolSet.getShovel());
        if (FabricLoader.getInstance().getEnvironmentType().equals(EnvType.CLIENT)) {
            addTooltip(toolSet.getSword(), style);
            addTooltip(toolSet.getAxe(), style);
            addTooltip(toolSet.getHoe(), style);
            addTooltip(toolSet.getPickaxe(), style);
            addTooltip(toolSet.getShovel(), style);
        }
    }

    @Environment(EnvType.CLIENT)
    public void addTooltip(class_1792 item, class_2583 style) {
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            class_5250 text = class_2561.method_43470("");
            if (stack.method_31574(item)) {
                text.method_10852(class_2561.method_43471("abilities.mythicmetals." + tooltip));
                text.method_10862(style);
                if (showLevel) {
                    text.method_27693(" ").method_10852(class_2561.method_43471("enchantment.level." + level));
                }
                if (lines.size() > 2) {
                    var enchantCount = stack.method_58657().method_57541();
                    lines.add(enchantCount + 1, text);
                } else lines.add(text);
            }
        });
    }

    public static void addTooltipOnStack(class_1799 stack, List<class_2561> lines, class_2583 style, String translationKey) {
        class_5250 text = class_2561.method_43470("");
        text.method_10852(class_2561.method_43471(translationKey));
        text.method_10862(style);
        if (lines.size() > 2) {
            var enchantCount = stack.method_58657().method_57541();
            lines.add(enchantCount + 1, text);
        } else lines.add(text);
    }
}
