package com.mythicmetals.armor;

import com.mythicmetals.MythicMetals;
import com.mythicmetals.entity.MythicEntityAttributes;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

public class CarmotShield implements Component, AutoSyncedComponent {
    private final class_1657 player;
    public float shieldHealth;
    public int renderTime;
    public int cooldown;

    public static final int MAX_COOLDOWN = 160;

    public CarmotShield(class_1657 player) {
        this.player = player;
        shieldHealth = 0;
        renderTime = 0;
        cooldown = 0;
    }

    public boolean shouldRenderShield() {
        return renderTime > 0;
    }

    public void damageShield(float damage) {
        shieldHealth = class_3532.method_15363(shieldHealth - damage, 0f, getMaxHealth());

        // Put the shield on cooldown when you take damage
        if (shieldHealth > 0) {
            renderTime = 20;
            cooldown = 50;
        }

        // Handle if the shield should break
        if (shieldHealth == 0) {
            // Set the shield to render the break animation once
            if (cooldown == 0) {
                renderTime = 30;
            }
            cooldown = MAX_COOLDOWN;
        }
    }

    public void tickShield() {
        if (player.method_37908() == null) return;

        // Prevent overshields
        if (shieldHealth > getMaxHealth()) {
            shieldHealth = getMaxHealth();
        }

        // Regenerate shield if not on cooldown
        if (shieldHealth < getMaxHealth()) {
            if (cooldown == 0) {
                shieldHealth = class_3532.method_15363(shieldHealth += 0.1f, 0f, this.getMaxHealth());
                renderTime = 40;
            } else {
                cooldown--;
            }
        }

        if (shouldRenderShield()) {
            renderTime--;
            MythicMetals.CARMOT_SHIELD.sync(player);
        }

        // No shield, stop rendering
        if (getMaxHealth() == 0) {
            renderTime = 0;
            shieldHealth = 0;
        }
    }

    // FIXME - This is likely causing some weird rendering
    public float getMaxHealth() {
        int result = 0;
        if (this.player.method_6127().method_45331(MythicEntityAttributes.CARMOT_SHIELD)) {
            return (float) this.player.method_6127().method_26852(MythicEntityAttributes.CARMOT_SHIELD);
        }
        return result;
    }

    @Override
    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        shieldHealth = tag.method_10583("health");
        renderTime = tag.method_10550("rendertime");
        cooldown = tag.method_10550("cooldown");
    }

    @Override
    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10548("health", shieldHealth);
        tag.method_10569("rendertime", renderTime);
        tag.method_10569("cooldown", cooldown);

    }
}
