package com.mythicmetals.armor;

import com.mythicmetals.entity.MythicEntityAttributes;
import com.mythicmetals.item.MythicItems;
import com.mythicmetals.misc.RegistryHelper;
import com.mythicmetals.registry.RegisterSounds;
import net.fabricmc.fabric.api.entity.event.v1.FabricElytraItem;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1770;
import net.minecraft.class_1799;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9285.class_9286;

public class CelestiumElytra extends class_1770 implements FabricElytraItem {
    public CelestiumElytra(class_1793 settings) {
        super(settings);
    }

    @Override
    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return ingredient.method_31574(MythicItems.CELESTIUM.getIngot());
    }

    @Override
    public class_6880<class_3414> method_31570() {
        return class_7923.field_41172.method_47983(RegisterSounds.EQUIP_CELESTIUM_ELYTRA);
    }

    public static boolean isWearing(class_1309 entity) {
        var stack = entity.method_6118(class_1304.field_6174);
        return stack.method_31574(MythicArmor.CELESTIUM_ELYTRA) && method_7804(stack);
    }

    @Override
    public void doVanillaElytraTick(class_1309 entity, class_1799 chestStack) {
        int nextRoll = entity.method_6003() + 1;

        if (!entity.method_37908().field_9236 && nextRoll % 10 == 0) {
            if ((nextRoll / 10) % 4 == 0) {
                chestStack.method_7970(1, entity, class_1304.field_6174);
            }

            entity.method_32876(class_5712.field_28158);
        }
    }

    public static class_9285 createDefaultAttributes() {
        var builder = class_9285.method_57480();
        var armor = new class_1322(RegistryHelper.id("celestium_elytra_armor_protection"), 5.0F, class_1322.class_1323.field_6328);
        var toughness = new class_1322(RegistryHelper.id("celestium_elytra_armor_toughness"), 3.0F, class_1322.class_1323.field_6328);
        var speed = new class_1322(RegistryHelper.id("celestium_elytra_speed_bonus"), 0.08F, class_1322.class_1323.field_6331);
        var rocketSpeedBonus = new class_1322(RegistryHelper.id("celestium_elytra_rocket_speed_bonus"), 0.20F, class_1322.class_1323.field_6331);
        builder.method_57487(class_5134.field_23724, armor, class_9274.field_49222);
        builder.method_57487(class_5134.field_23725, toughness, class_9274.field_49222);
        builder.method_57487(class_5134.field_23719, speed, class_9274.field_49222);
        builder.method_57487(MythicEntityAttributes.ELYTRA_ROCKET_SPEED, rocketSpeedBonus, class_9274.field_49222);
        return builder.method_57486();
    }
}
