package com.mythicmetals.armor;

import com.mythicmetals.client.models.HelmetModel;
import com.mythicmetals.client.models.MythicModelHandler;
import com.mythicmetals.misc.RegistryHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.item.*;
import org.jetbrains.annotations.NotNull;

public class HallowedArmor extends class_1738 {

    @Environment(EnvType.CLIENT)
    private class_572<class_1309> model;
    public final class_1738.class_8051 field_41933;

    public HallowedArmor(class_1738.class_8051 type, class_1793 settings) {
        this(MythicArmorMaterials.HALLOWED, type, settings);
    }

    public HallowedArmor(class_1741 material, class_1738.class_8051 slot, class_1793 settings) {
        super(RegistryHelper.getEntry(material), slot, settings);
        this.field_41933 = slot;
    }

    @Environment(EnvType.CLIENT)
    public class_572<class_1309> getArmorModel() {
        if (model == null) {
            model = provideArmorModelForSlot(field_41933.method_48399());
        }
        return model;
    }

    @Environment(EnvType.CLIENT)
    protected class_572<class_1309> provideArmorModelForSlot(class_1304 slot) {
        var models = class_310.method_1551().method_31974();
        var root = models.method_32072(MythicModelHandler.HALLOWED_ARMOR);
        return new HelmetModel(root, slot);
    }

    @NotNull
    public class_2960 getArmorTexture(class_1799 stack, class_1304 slot) {
        return RegistryHelper.id("textures/models/hallowed_model.png");
    }
}
