package com.mythicmetals.armor;

import com.mythicmetals.client.models.MythicModelHandler;
import com.mythicmetals.client.models.TidesingerBipedModel;
import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.TidesingerPatternComponent;
import com.mythicmetals.misc.RegistryHelper;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1741;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5599;
import net.minecraft.class_572;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import java.util.List;

public class TidesingerArmor extends HallowedArmor {

    @Environment(EnvType.CLIENT)
    private class_572<class_1309> model;
    public final class_8051 type;

    public TidesingerArmor(class_8051 type, class_1793 settings) {
        this(MythicArmorMaterials.TIDESINGER, type, settings);
    }

    public TidesingerArmor(class_1741 material, class_8051 slot, class_1793 settings) {
        super(material, slot, settings.method_57349(MythicDataComponents.TIDESINGER, TidesingerPatternComponent.empty()));
        this.field_41933 = slot;
    }

    @Environment(EnvType.CLIENT)
    public class_572<class_1309> getArmorModel() {
        if (model == null) {
            model = provideArmorModelForSlot(field_41933.method_48399());
        }
        return model;
    }

    @Environment(EnvType.CLIENT)
    @Override
    protected class_572<class_1309> provideArmorModelForSlot(class_1304 slot) {
        var models = class_310.method_1551().method_31974();
        var root = models.method_32072(MythicModelHandler.TIDESINGER);
        return new TidesingerBipedModel(root, slot);
    }

    // TODO - Feels like magic string, maybe refactor
    @NotNull
    @Override
    public class_2960 getArmorTexture(class_1799 stack, class_1304 slot) {
        var component = stack.method_57825(MythicDataComponents.TIDESINGER, TidesingerPatternComponent.empty());
        String model = switch (component.pattern()) {
            case "brain" -> "textures/models/tidesinger_model_brain.png";
            case "bubble" -> "textures/models/tidesinger_model_bubble.png";
            case "fire" -> "textures/models/tidesinger_model_fire.png";
            case "horn" -> "textures/models/tidesinger_model_horn.png";
            case "tube" -> "textures/models/tidesinger_model_tube.png";
            default -> "textures/models/tidesinger_model.png";
        };
        return RegistryHelper.id(model);
    }

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> lines, class_1836 type) {
        if (stack.method_57826(MythicDataComponents.TIDESINGER)) {
            stack.method_57824(MythicDataComponents.TIDESINGER).method_57409(context, lines::add, type);
        }
    }
}
