package com.mythicmetals.block;

import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.UpgradeComponent;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.item.MythicItems;
import io.wispforest.owo.particles.ClientParticles;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalEnchantmentTags;
import net.minecraft.block.*;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2431;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_6016;
import net.minecraft.class_6880;
import net.minecraft.class_9304;

public class BanglumOreBlock extends class_2431 {
    public BanglumOreBlock(class_4970.class_2251 settings) {
        super(class_6016.field_29942, settings);
    }

    @Override
    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        int rng = random.method_43048(130);
        if (rng < 2 && world.method_8597().comp_644()) {
            ClientParticles.setParticleCount(12);
            ClientParticles.spawnCenteredOnBlock(class_2398.field_11237, world, pos, 4.5D);
        } else if (rng == 69) {
            ClientParticles.setParticleCount(6);
            ClientParticles.spawnCenteredOnBlock(class_2398.field_11237, world, pos, 3.5D);
        }
        super.method_9496(state, world, pos, random);
    }

    /**
     * Occasionally, or in some cases often, explode when mined
     */
    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        int chance = world.method_8597().comp_644() ? 35 : 7;
        class_5819 random = class_5819.method_43047();
        var stack = player.method_6047();
        var upgrades = stack.method_57825(MythicDataComponents.UPGRADES, UpgradeComponent.empty(2));

        // This living ore is allergic to Efficiency and Fortune, but is defused by Silk Touch
        if (stack.method_7942()) {
            var enchantments = class_1890.method_57532(stack);
            for (var enchantment : enchantments.method_57534()) {
                if (enchantment.method_40220(MythicTags.SILK_TOUCH_LIKE)) {
                    chance -= 45;
                }
                if (enchantment.method_40220(ConventionalEnchantmentTags.INCREASE_BLOCK_DROPS)) {
                    chance += enchantments.method_57536(enchantment) * 7;
                }
                if (enchantment.method_40220(MythicTags.INCREASES_MINING_SPEED)) {
                    chance += enchantments.method_57536(enchantment) * 5;
                }
            }
        }

        // Extra fortune = more allergic
        if (upgrades.hasUpgrade(MythicItems.Mats.CARMOT_STONE)) {
            chance += 10;
        }

        // Banglum Defuser really living up to its name
        if (upgrades.hasUpgrade(MythicItems.Mats.STORMYX_SHELL)) {
            chance -= 92;
        }

        // Clamp at 80%, just so you don't use these to *reliably* blow up stuff
        chance = class_3532.method_15340(chance, 0, 80);

        // Roll the dice
        if (random.method_43048(100) <= chance && !player.method_7337()) {
            if (!world.field_9236) {
                world.method_8650(pos, false);
                explode(world, pos);
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    private void explode(class_1937 world, class_2338 pos) {
        if (world.method_8597().comp_644()) {
            world.method_8437(null, pos.method_10263(), pos.method_10264() + 0.6, pos.method_10260(), 3.2F, class_1937.class_7867.field_40889);
        } else {
            world.method_8437(null, pos.method_10263(), pos.method_10264(), pos.method_10260(), 0.3F, class_1937.class_7867.field_40889);
        }
    }
}
