package com.mythicmetals.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.block.*;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2241;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2452;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2768;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.fluid.*;
import net.minecraft.item.*;
import net.minecraft.state.property.*;
import net.minecraft.world.*;
import org.jetbrains.annotations.Nullable;
import java.util.Optional;

public class PalladiumRailBlock extends class_2241 implements Lavaloggable {

    public static final class_2754<class_2768> SHAPE = class_2741.field_12507;
    public static final MapCodec<PalladiumRailBlock> CODEC = method_54094(PalladiumRailBlock::new);
    public static final class_2746 LAVALOGGED = class_2746.method_11825("lavalogged");

    @Override
    protected void method_9477(class_2680 state, class_1937 world, class_2338 pos, class_2248 neighbor) {
        if (neighbor.method_9564().method_26219() && new class_2452(world, pos, state).method_10460() == 3) {
            this.method_9475(world, pos, state, false);
        }
    }

    public PalladiumRailBlock(class_2251 settings) {
        super(false, settings);
        this.method_9590(this.field_10647.method_11664()
            .method_11657(SHAPE, class_2768.field_12665)
            .method_11657(LAVALOGGED, Boolean.FALSE)
            .method_11657(field_27096, Boolean.FALSE)
        );
    }

    @Override
    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        class_2768 railShape = state.method_11654(SHAPE);

        return state.method_11657(SHAPE, switch (rotation) {
            case field_11464 -> {
                switch (railShape) {
                    case field_12665:
                        yield class_2768.field_12665;
                    case field_12674:
                        yield class_2768.field_12674;
                    case field_12667:
                        yield class_2768.field_12666;
                    case field_12666:
                        yield class_2768.field_12667;
                    case field_12670:
                        yield class_2768.field_12668;
                    case field_12668:
                        yield class_2768.field_12670;
                    case field_12664:
                        yield class_2768.field_12672;
                    case field_12671:
                        yield class_2768.field_12663;
                    case field_12672:
                        yield class_2768.field_12664;
                    case field_12663:
                        yield class_2768.field_12671;
                    default:
                        throw new MatchException(null, null);
                }
            }
            case field_11465 -> {
                switch (railShape) {
                    case field_12665:
                        yield class_2768.field_12674;
                    case field_12674:
                        yield class_2768.field_12665;
                    case field_12667:
                        yield class_2768.field_12670;
                    case field_12666:
                        yield class_2768.field_12668;
                    case field_12670:
                        yield class_2768.field_12666;
                    case field_12668:
                        yield class_2768.field_12667;
                    case field_12664:
                        yield class_2768.field_12663;
                    case field_12671:
                        yield class_2768.field_12664;
                    case field_12672:
                        yield class_2768.field_12671;
                    case field_12663:
                        yield class_2768.field_12672;
                    default:
                        throw new MatchException(null, null);
                }
            }
            case field_11463 -> {
                switch (railShape) {
                    case field_12665:
                        yield class_2768.field_12674;
                    case field_12674:
                        yield class_2768.field_12665;
                    case field_12667:
                        yield class_2768.field_12668;
                    case field_12666:
                        yield class_2768.field_12670;
                    case field_12670:
                        yield class_2768.field_12667;
                    case field_12668:
                        yield class_2768.field_12666;
                    case field_12664:
                        yield class_2768.field_12671;
                    case field_12671:
                        yield class_2768.field_12672;
                    case field_12672:
                        yield class_2768.field_12663;
                    case field_12663:
                        yield class_2768.field_12664;
                    default:
                        throw new MatchException(null, null);
                }
            }
            default -> railShape;
        });
    }

    @Override
    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        class_2768 railShape = state.method_11654(SHAPE);
        switch (mirror) {
            case field_11300:
                return switch (railShape) {
                    case field_12670 -> state.method_11657(SHAPE, class_2768.field_12668);
                    case field_12668 -> state.method_11657(SHAPE, class_2768.field_12670);
                    case field_12664 -> state.method_11657(SHAPE, class_2768.field_12663);
                    case field_12671 -> state.method_11657(SHAPE, class_2768.field_12672);
                    case field_12672 -> state.method_11657(SHAPE, class_2768.field_12671);
                    case field_12663 -> state.method_11657(SHAPE, class_2768.field_12664);
                    default -> super.method_9569(state, mirror);
                };
            case field_11301:
                switch (railShape) {
                    case field_12667: return state.method_11657(SHAPE, class_2768.field_12666);
                    case field_12666:
                        return state.method_11657(SHAPE, class_2768.field_12667);
                    case field_12664:
                        return state.method_11657(SHAPE, class_2768.field_12671);
                    case field_12671:
                        return state.method_11657(SHAPE, class_2768.field_12664);
                    case field_12672:
                        return state.method_11657(SHAPE, class_2768.field_12663);
                    case field_12663:
                        return state.method_11657(SHAPE, class_2768.field_12672);
                    case field_12670:
                    case field_12668:
                    default:
                        break;
                }
        }

        return super.method_9569(state, mirror);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(SHAPE, LAVALOGGED, field_27096);
    }

    @Override
    public boolean method_10310(@Nullable class_1657 player, class_1922 world, class_2338 pos, class_2680 state, class_3611 fluid) {
        return fluid == class_3612.field_15908;
    }

    @Override
    public boolean method_10311(class_1936 world, class_2338 pos, class_2680 state, class_3610 fluidState) {
        if (!state.method_11654(LAVALOGGED) && fluidState.method_15772() == class_3612.field_15908) {
            if (!world.method_8608()) {
                world.method_8652(pos, state.method_11657(LAVALOGGED, Boolean.TRUE), class_2248.field_31036);
                world.method_39281(pos, fluidState.method_15772(), fluidState.method_15772().method_15789(world));
            }

            return true;
        } else {
            return false;
        }
    }

    @Override
    public class_1799 method_9700(@Nullable class_1657 player, class_1936 world, class_2338 pos, class_2680 state) {
        if (state.method_11654(LAVALOGGED)) {
            world.method_8652(pos, state.method_11657(LAVALOGGED, Boolean.FALSE), class_2248.field_31036);
            if (!state.method_26184(world, pos)) {
                world.method_22352(pos, true);
            }

            return new class_1799(class_1802.field_8187);
        } else {
            return class_1799.field_8037;
        }
    }

    @Override
    public Optional<class_3414> method_32351() {
        return class_3612.field_15908.method_32359();
    }

    @Override
    public MapCodec<PalladiumRailBlock> method_53969() {
        return field_46280;
    }

    @Override
    public class_2769<class_2768> method_9474() {
        return SHAPE;
    }

    @Override
    protected class_3610 method_9545(class_2680 state) {
        return state.method_11654(LAVALOGGED) ? class_3612.field_15908.method_15729(false) : super.method_9545(state);
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        class_3610 fluidState = ctx.method_8045().method_8316(ctx.method_8037());
        boolean bl = fluidState.method_15772() == class_3612.field_15908;
        class_2680 blockState = super.method_9564();
        class_2350 direction = ctx.method_8042();
        boolean bl2 = direction == class_2350.field_11034 || direction == class_2350.field_11039;
        return blockState.method_11657(this.method_9474(), bl2 ? class_2768.field_12674 : class_2768.field_12665).method_11657(LAVALOGGED, bl);
    }

    // TODO - Move this somewhere nicer
    public static boolean isLavaLogged(class_2680 state) {
        return state.method_11654(LAVALOGGED);
    }
}
