package com.mythicmetals.block.entity;

import com.mythicmetals.block.AquariumResonatorBlock;
import com.mythicmetals.block.ConduitPowered;
import com.mythicmetals.misc.MythicParticleSystem;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import net.minecraft.util.math.*;
import java.util.List;

public class AquariumResonatorBlockEntity extends class_2586 implements ConduitPowered {
    public static final int MAX_RANGE = 24;
    private boolean activated = false;
    private int activeTime = 50;

    public AquariumResonatorBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    public AquariumResonatorBlockEntity(class_2338 pos, class_2680 state) {
        super(RegisterBlockEntityTypes.AQUARIUM_RESONATOR, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, AquariumResonatorBlockEntity blockEntity) {
        if (world.method_8608()) return;
        if (blockEntity.activated && world.method_8510() % 40L == 0) {
            if (!state.method_11654(AquariumResonatorBlock.ACTIVE)) {
                state = state.method_11657(AquariumResonatorBlock.ACTIVE, Boolean.TRUE);
                world.method_8652(pos, state, class_2248.field_31036);
                method_31663(world, pos, state);
            }
            MythicParticleSystem.RESONATOR_PARTICLES.spawn(world, pos.method_46558());
            empowerNearbyEntities(world, pos, state, blockEntity);
        }
        blockEntity.activeTime = class_3532.method_15340(blockEntity.activeTime - 1, 0, 150);
        if (blockEntity.activeTime == 0) {
            blockEntity.activated = false;
            if (state.method_11654(AquariumResonatorBlock.ACTIVE)) {
                state = state.method_11657(AquariumResonatorBlock.ACTIVE, Boolean.FALSE);
                world.method_8652(pos, state, class_2248.field_31036);
                method_31663(world, pos, state);
            }
        }
    }

    private static class_238 getEffectZone(class_2338 pos) {
        return new class_238(pos).method_1014(MAX_RANGE);
    }

    private static void empowerNearbyEntities(class_1937 world, class_2338 pos, class_2680 state, AquariumResonatorBlockEntity blockEntity) {
        List<class_1309> list = world.method_8390(
                class_1309.class, getEffectZone(pos), entity -> entity.method_5709() && entity.method_5721()
        );

        list.forEach(livingEntity -> {
            MythicParticleSystem.RESONATOR_POWER_PARTICLES.spawn(world, livingEntity.method_19538());
            livingEntity.method_6092(new class_1293(class_1294.field_5927, 160, 1, true, false, true));
        });
    }

    @Override
    public void activate() {
        this.activated = true;
        this.activeTime = 150;
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.activeTime = nbt.method_10550("active_time");
        this.activated = nbt.method_10577("activated");
        super.method_11014(nbt, registryLookup);
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10569("active_time", activeTime);
        nbt.method_10556("activated", activated);
        super.method_11014(nbt, registryLookup);
    }
}