package com.mythicmetals.client;

import D;
import com.mythicmetals.MythicMetals;
import com.mythicmetals.armor.*;
import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.block.entity.RegisterBlockEntityTypes;
import com.mythicmetals.client.models.MythicModelHandler;
import com.mythicmetals.client.rendering.*;
import com.mythicmetals.compat.IsometricArmorStandExporter;
import com.mythicmetals.component.*;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.entity.MythicEntities;
import com.mythicmetals.item.tools.*;
import com.mythicmetals.misc.*;
import com.mythicmetals.mixin.WorldRendererInvoker;
import io.wispforest.owo.ui.util.Delta;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.item.v1.ItemTooltipCallback;
import net.fabricmc.fabric.api.client.rendering.v1.*;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1058;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3726;
import net.minecraft.class_3883;
import net.minecraft.class_3965;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5272;
import net.minecraft.class_5616;
import net.minecraft.class_572;
import net.minecraft.class_591;
import net.minecraft.class_742;
import net.minecraft.class_7923;
import net.minecraft.class_8053;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9334;
import net.minecraft.class_9701;
import net.minecraft.client.render.*;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;

public class MythicMetalsClient implements ClientModInitializer {
    private long lastTime;
    private float time;
    public static class_811 mode;

    @Override
    public void onInitializeClient() {
        MythicModelHandler.init((loc, def) -> EntityModelLayerRegistry.registerModelLayer(loc, () -> def));

        renderHammerOutline();
        registerArmorRenderer();
        registerModelPredicates();
        registerSwirlRenderer();

        LivingEntityFeatureRenderEvents.ALLOW_CAPE_RENDER.register(player -> !CelestiumElytra.isWearing(player));

        EntityRendererRegistry.register(MythicEntities.PALLADIUM_MINECART_ENTITY_TYPE, PalladiumMinecartRenderer::new);
        EntityRendererRegistry.register(MythicEntities.BANGLUM_TNT_MINECART_ENTITY_TYPE, BanglumTntMinecartEntityRenderer::new);
        EntityRendererRegistry.register(MythicEntities.BANGLUM_TNT_ENTITY_TYPE, BanglumTntEntityRenderer::new);
        EntityRendererRegistry.register(MythicEntities.BANGLUM_NUKE_ENTITY_TYPE, BanglumNukeEntityRenderer::new);
        EntityRendererRegistry.register(MythicEntities.STAR_PLATINUM_ARROW_ENTITY_TYPE, StarPlatinumArrowEntityRenderer::new);
        EntityRendererRegistry.register(MythicEntities.RUNITE_ARROW_ENTITY_TYPE, RuniteArrowEntityRenderer::new);

        class_5616.method_32144(RegisterBlockEntityTypes.ENCHANTED_MIDAS_GOLD_BLOCK, EnchantedMidasBlockEntityRenderer::new);

        ColorProviderRegistry.ITEM.register(UsefulSingletonForColorUtil::potionColor, MythicTools.TIPPED_RUNITE_ARROW);

        CarmotShieldHudHandler.init();
        ClientTickEvents.END_CLIENT_TICK.register(client -> CarmotShieldHudHandler.tick());

        BlockRenderLayerMap.INSTANCE.putBlock(MythicBlocks.CARMOT_BELL_BLOCK, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MythicBlocks.PALLADIUM_RAIL, class_1921.method_23579());
        BlockRenderLayerMap.INSTANCE.putBlock(MythicBlocks.AQUARIUM_GLASS, class_1921.method_23583());

        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23583(), MythicBlocks.KYBER.getStorageBlock());

        if (FabricLoader.getInstance().isModLoaded("isometric-renders")) {
            ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
                IsometricArmorStandExporter.register(dispatcher);
            });
        }

        registerTooltipCallbacks();
    }

    @SuppressWarnings("unchecked")
    private void registerSwirlRenderer() {
        LivingEntityFeatureRendererRegistrationCallback.EVENT.register((entityType, entityRenderer, registrationHelper, context) -> {
            if (entityType != class_1299.field_6097) return;
            registrationHelper.register(
                new PlayerEnergySwirlFeatureRenderer(
                    (class_3883<class_742, class_591<class_742>>) entityRenderer,
                    context.method_32170()));
        });
    }

    /**
     * Renders the outline of a {@link HammerBase hammer item.}
     */
    private void renderHammerOutline() {
        WorldRenderEvents.BLOCK_OUTLINE.register((worldRenderContext, blockOutlineContext) -> {
            if (!blockOutlineContext.entity().method_31747()) return true;
            var player = (class_1657) blockOutlineContext.entity();

            // Only render the outline if you are hovering over something the hammer can break
            var stack = player.method_6047();
            if (stack.method_7909() instanceof HammerBase hammer
                && !blockOutlineContext.blockState().method_26215()
                && hammer.method_58405(stack, blockOutlineContext.blockState())) {

                var reach = BlockBreaker.getReachDistance(player);
                class_3965 blockHitResult = (class_3965) player.method_5745(reach, 1, false);

                var facing = blockHitResult.method_17780().method_10153();
                var blocks = BlockBreaker.findBlocks(facing, blockOutlineContext.blockPos(), hammer.getDepth());
                var originalPos = blockOutlineContext.blockPos();

                // Create VoxelShapes out of the block positions and put them in a list
                var voxels = new ArrayList<class_265>();

                for (class_2338 blockPos : blocks) {
                    var blockState = player.method_37908().method_8320(blockPos);
                    if (!blockState.method_26215() && hammer.method_58405(stack, blockState)) {
                        voxels.add(blockState.method_26172(
                                worldRenderContext.world(),
                                blockPos,
                                class_3726.method_16195(blockOutlineContext.entity())
                            ).method_1096(blockPos.method_10263() - originalPos.method_10263(),
                                blockPos.method_10264() - originalPos.method_10264(),
                                blockPos.method_10260() - originalPos.method_10260())
                        );
                    }
                }

                // Combine and render the full shape
                var outlineOptional = voxels.stream().reduce(class_259::method_1084);
                if (outlineOptional.isEmpty()) return true;

                var outlineShape = outlineOptional.get();

                WorldRendererInvoker.mythicmetals$drawShapeOutline(
                    worldRenderContext.matrixStack(),
                    worldRenderContext.consumers().getBuffer(class_1921.method_23594()),
                    outlineShape,
                    originalPos.method_10263() - blockOutlineContext.cameraX(),
                    originalPos.method_10264() - blockOutlineContext.cameraY(),
                    originalPos.method_10260() - blockOutlineContext.cameraZ(),
                    0, 0, 0, 0.4F //RGBA
                );
                // Cancel the event to prevent the middle outline from rendering
                return false;
            }

            // Keep moving along if we reach this point
            return true;
        });
    }

    private void registerArmorRenderer() {
        class_1792[] armors = class_7923.field_41178.method_10220()
            .filter(i -> i instanceof HallowedArmor
                && class_7923.field_41178.method_29113(i).get().method_29177().method_12836().equals(MythicMetals.MOD_ID))
            .toArray(class_1792[]::new);

        ArmorRenderer renderer = (matrices, vertexConsumer, stack, entity, slot, light, original) -> {

            HallowedArmor armor = (HallowedArmor) stack.method_7909();
            var model = armor.getArmorModel();
            var texture = armor.getArmorTexture(stack, slot);
            original.method_2818(model);
            ArmorRenderer.renderPart(matrices, vertexConsumer, light, stack, model, texture);

            // Armor trim time
            if (!stack.method_31574(MythicArmor.HALLOWED.getHelmet())) {
                var trimComponent = stack.method_57824(class_9334.field_49607);
                if (trimComponent != null) {
                    var atlas = class_310.method_1551().method_1549(class_4722.field_42071);
                    class_1058 sprite = atlas.apply(slot == class_1304.field_6172 ? trimComponent.method_48434(armor.method_7686()) : trimComponent.method_48436(armor.method_7686()));
                    class_4588 trimVertexConsumer = sprite.method_24108(
                        class_918.method_29711(vertexConsumer, class_4722.method_48480(trimComponent.method_48424().comp_349().comp_1905()), true, stack.method_7958())
                    );
                    model.method_60879(matrices, trimVertexConsumer, light, class_4608.field_21444);
                }
            }
        };
        ArmorRenderer.register(renderer, armors);
    }

    private void registerModelPredicates() {
        class_5272.method_27879(
            MythicTools.LEGENDARY_BANGLUM.getPickaxe(), RegistryHelper.id("is_primed"),
            (stack, world, entity, seed) -> BanglumPick.isCoolingDown(entity, stack) ? 0 : 1
        );

        class_5272.method_27879(
            MythicTools.LEGENDARY_BANGLUM.getShovel(), RegistryHelper.id("is_primed"),
            (stack, world, entity, seed) -> BanglumShovel.isCoolingDown(entity, stack) ? 0 : 1
        );

        class_5272.method_27879(
            MythicTools.MYTHRIL_DRILL, RegistryHelper.id("is_active"),
            (stack, world, entity, seed) -> stack.method_57825(MythicDataComponents.DRILL, DrillComponent.DEFAULT).hasFuel() ? 0 : 1
        );

        registerMidasPredicates(MythicTools.MIDAS_GOLD_SWORD);
        registerMidasPredicates(MythicTools.GILDED_MIDAS_GOLD_SWORD);
        registerMidasPredicates(MythicTools.ROYAL_MIDAS_GOLD_SWORD);

        class_5272.method_27881(RegistryHelper.id("in_world"), (itemStack, world, livingEntity, i) -> {
            if (mode == null) {
                return 1.0f;
            }

            return mode.equals(class_811.field_4317) ? 0.0F : 1.0f;
        });

        class_5272.method_27879(MythicTools.STORMYX_SHIELD, RegistryHelper.id("blocking"), new ShieldUsePredicate());

        class_5272.method_27881(RegistryHelper.id("funny_day"), (stack, world, entity, seed) ->
            (StringUtilsAtHome.isFunnyDay()) ? 1 : 0);

        class_5272.method_27879(MythicTools.PLATINUM_WATCH, RegistryHelper.id("time"), (stack, world, entity, seed) -> {
            if (entity == null || entity.method_37908() == null) {
                return 0.0F;
            }
            return this.getTime(entity.method_37908());
        });

    }

    public void registerTooltipCallbacks() {
        ItemTooltipCallback.EVENT.register((stack, context, type, lines) -> {
            int index = 1;

            if (stack.method_31573(MythicTags.BONUS_FORTUNE)) {
                lines.add(index, class_2561.method_43471("abilities.mythicmetals.bonus_fortune").method_54663(UsefulSingletonForColorUtil.MetalColors.CARMOT.rgb()));
            }

            if (stack.method_31573(MythicTags.BONUS_LOOTING)) {
                lines.add(index, class_2561.method_43471("abilities.mythicmetals.bonus_looting").method_54663(UsefulSingletonForColorUtil.MetalColors.CARMOT.rgb()));
            }

            if (lines.size() > 2) {
                index += stack.method_58657().method_57541();
            }

            if (stack.method_57826(MythicDataComponents.PROMETHEUM)) {
                var component = stack.method_57825(MythicDataComponents.PROMETHEUM, PrometheumComponent.DEFAULT);
                if (type.method_8035()) {
                    lines.add(index, class_2561.method_43469("tooltip.prometheum.repaired", component.durabilityRepaired())
                        .method_54663(UsefulSingletonForColorUtil.MetalColors.PROMETHEUM.rgb())
                    );
                }

                lines.add(index, class_2561.method_43471("tooltip.prometheum.regrowth").method_54663(UsefulSingletonForColorUtil.MetalColors.PROMETHEUM.rgb()));
                if (component.isOvergrown()) {
                    lines.add(index, class_2561.method_43471("tooltip.prometheum.overgrown").method_54663(UsefulSingletonForColorUtil.MetalColors.PROMETHEUM.rgb()));
                }
                if (class_1890.method_60142(stack, class_9701.field_51656)) {
                    lines.add(index, class_2561.method_43471("tooltip.prometheum.engrained").method_54663(UsefulSingletonForColorUtil.MetalColors.PROMETHEUM.rgb()));
                }
            }
        });


    }

    private float getTime(class_1937 world) {
        if (world.method_8532() != this.lastTime) {
            this.lastTime = world.method_8532();
            this.time += Delta.compute(
                this.time,
                (world.method_8532()) / 24000.0f,
                class_310.method_1551().method_60646().method_60636() / 2.0f
            );
        }

        return this.time;
    }

    public void registerMidasPredicates(class_1792 item) {
        class_5272.method_27879(item, RegistryHelper.id("midas_gold_count"),
            (stack, world, entity, seed) -> {
                int goldCount = stack.method_57825(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(0)).goldFolded();
                return MidasGoldSword.countGold(goldCount);
            });
    }

}
