package com.mythicmetals.client.models;

import com.mythicmetals.misc.RegistryHelper;
import com.mythicmetals.mixin.EntityModelLayersAccessor;
import net.minecraft.class_2960;
import net.minecraft.class_5601;
import net.minecraft.class_5605;
import net.minecraft.class_5607;
import net.minecraft.class_580;
import net.minecraft.class_591;
import net.minecraft.client.render.entity.model.*;
import java.util.function.BiConsumer;

public class MythicModelHandler {
    public static final class_5601 BANGLUM = model("banglum_armor");
    public static final class_5601 CARMOT_SWIRL = model("carmot_swirl");
    public static final class_5601 HALLOWED_ARMOR = model("hallowed_armor");
    public static final class_5601 METALLURGIUM = model("metallurgium_armor");
    public static final class_5601 RUNITE = model("runite_armor");
    public static final class_5601 TIDESINGER = model("tidesinger");
    public static final class_5601 BANGLUM_TNT_MINECART = model("banglum_tnt_minecart");
    public static final class_5601 PALLADIUM_MINECART = model("palladium_minecart");
    public static final class_2960 HALLOWED_CAPE = RegistryHelper.id("textures/models/hallowed_cape.png");
    public static final class_2960 STAR_PLATINUM_CLOAK = RegistryHelper.id("textures/models/star_platinum_cloak.png");

    public static void init(BiConsumer<class_5601, class_5607> consumer) {
        consumer.accept(BANGLUM_TNT_MINECART, class_580.method_32020());
        consumer.accept(PALLADIUM_MINECART, class_580.method_32020());
        consumer.accept(BANGLUM, class_5607.method_32110(BanglumArmorModel.getModelData(), 64, 32));
        consumer.accept(CARMOT_SWIRL, class_5607.method_32110(class_591.method_32028(new class_5605(1.15f), false), 64, 32));
        consumer.accept(HALLOWED_ARMOR, class_5607.method_32110(HallowedArmorModel.getModelData(), 64, 32));
        consumer.accept(METALLURGIUM, class_5607.method_32110(MetallurgiumArmorModel.getModelData(), 32, 32));
        consumer.accept(RUNITE, class_5607.method_32110(RuniteArmorModel.getModelData(), 64, 32));
        consumer.accept(TIDESINGER, class_5607.method_32110(TidesingerArmorModel.getModelData(), 128, 128));
    }

    /**
     * Add a custom model layer into the global map for loading<br>
     * Shoutouts to williewillus for this implementation:
     * <a href="https://github.com/VazkiiMods/Botania/blob/1.18.x-fabric/src/main/java/vazkii/botania/client/model/ModModelLayers.java">Source</a>
     *
     * @see net.minecraft.class_5602#LAYERS
     */
    public static class_5601 model(String name, String layer) {
        var result = new class_5601(RegistryHelper.id(name), layer);
        EntityModelLayersAccessor.getLAYERS().add(result);
        return result;
    }

    public static class_5601 model(String name) {
        return model(name, "main");
    }
}
