package com.mythicmetals.client.rendering;

import com.mythicmetals.client.models.RainbowShieldModel;
import com.mythicmetals.misc.UsefulSingletonForColorUtil;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.client.render.*;
import org.joml.Vector3f;

public class StormyxShieldRenderer {
    private static final class_2960 WORLD_BORDER = class_2960.method_60654("textures/misc/forcefield.png");

    /**
     * Renders the model of the Stormyx Rainbow Shield, a fancy localized worldborder
     */
    public static void renderRainbowShield(class_4587 matrices, class_4597 vcp, int light, class_742 player) {
        matrices.method_22903();
        // Rainbow Handling
        double delta = System.currentTimeMillis() / 45.0;

        // Create and render rainbow shield
        var part = RainbowShieldModel.getTexturedModelData().method_32109();
        part.method_41924(new Vector3f(player.method_55693() - 1, player.method_55693() - 1, player.method_55693() - 1));
        part.method_22699(
            matrices,
            vcp.getBuffer(class_1921.method_23018(WORLD_BORDER, (float) ((delta * .005f) % 1f), (float) (delta * .005f % 1f))),
            light,
            class_4608.field_21444,
            UsefulSingletonForColorUtil.rainbow());
        matrices.method_22909();
    }
}
