package com.mythicmetals.compat;

import com.glisco.isometricrenders.render.BatchRenderable;
import com.glisco.isometricrenders.render.EntityRenderable;
import com.glisco.isometricrenders.screen.RenderScreen;
import com.glisco.isometricrenders.screen.ScreenScheduler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mythicmetals.armor.ArmorSet;
import com.mythicmetals.armor.MythicArmor;
import com.mythicmetals.armor.TidesingerArmor;
import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.TidesingerPatternComponent;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1299;
import net.minecraft.class_1531;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_9326;
import java.util.ArrayList;
import java.util.List;

import static net.fabricmc.fabric.api.client.command.v2.ClientCommandManager.literal;

public class IsometricArmorStandExporter {

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register(literal("mythicmetals-batch-render-armor")
            .executes(IsometricArmorStandExporter::batchRenderArmor)
        );
    }

    public static int batchRenderArmor(CommandContext<FabricClientCommandSource> context) {
        if (MythicArmor.ARMOR_MAP.isEmpty()) {
            context.getSource().sendFeedback(class_2561.method_43470("Unable to summon. Somehow the armor map is empty..."));
            return 0; // "how could this happen to me? I made my mistakes..."
        }

        List<EntityRenderable> renderables = new ArrayList<>();

        MythicArmor.ARMOR_MAP.values().forEach(armorSet -> {
            if (!armorSet.equals(MythicArmor.TIDESINGER)) {
            // Configure the armor stand to our liking
            var armorStand = new class_1531(class_1299.field_6131, context.getSource().getWorld());
            armorSet.getArmorItems().forEach(armorItem -> {
                var armorStack = new class_1799(armorItem);
                armorStand.method_5673(armorItem.method_7685(), armorStack);
            });
            armorStand.method_6907(true);
            armorStand.method_5648(true);
            renderables.add(new EntityRenderable(armorStand));
            }
        });

        // Handle Tidesinger specifically, since it has five distinct variants
        TidesingerPatternComponent.TIDESINGER_VARIANTS.keySet().forEach(patternItem -> {
            var armorStand = new class_1531(class_1299.field_6131, context.getSource().getWorld());
            var armorSet = MythicArmor.TIDESINGER;
            armorSet.getArmorItems().forEach(armorItem -> {
                var armorStack = new class_1799(armorItem.method_40131(), 1, class_9326.method_57841().method_57854(MythicDataComponents.TIDESINGER, TidesingerPatternComponent.fromItem(patternItem)).method_57852());
                armorStand.method_5673(armorItem.method_7685(), armorStack);
            });
            armorStand.method_6907(true);
            armorStand.method_5648(true);
            renderables.add(new EntityRenderable(armorStand));
        });

        var batchRender = BatchRenderable.of("mythicmetals", renderables);
        var renderScreen = new RenderScreen(batchRender);

        ScreenScheduler.schedule(renderScreen);

        return 1;
    }
}
