package com.mythicmetals.compat;

import com.mythicmetals.component.GoldFoldedComponent;
import com.mythicmetals.item.tools.MidasGoldSword;
import com.mythicmetals.recipe.MidasFoldingRecipe;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.DefaultSmithingDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_8786;
import java.util.Arrays;
import java.util.List;

import static com.mythicmetals.component.MythicDataComponents.GOLD_FOLDED;
import static com.mythicmetals.item.tools.MidasGoldSword.Type.*;

public class MidasFoldingDisplay extends DefaultSmithingDisplay {
    class_1856 template;
    class_1856 base;
    class_1856 addition;
    class_1799 outputStack;

    public MidasFoldingDisplay(class_8786<MidasFoldingRecipe> recipe) {
        super(
            recipe.comp_1933(),
            recipe.comp_1932(),
            List.of(
                EntryIngredients.ofIngredient(recipe.comp_1933().template()),
                EntryIngredients.ofIngredient(recipe.comp_1933().base()),
                EntryIngredients.ofIngredient(recipe.comp_1933().addition())
            )
        );

        this.template = recipe.comp_1933().template();
        this.base = recipe.comp_1933().base();
        this.addition = recipe.comp_1933().addition();
        this.outputStack = recipe.comp_1933().result();

    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        if (this.base != null && this.addition != null && outputStack != null) {
            var inputStack = Arrays.stream(this.base.method_8105()).findFirst().orElseGet(() -> new class_1799(class_1802.field_8162)).method_7972();
            // Handle folding recipes, which usually follow the pattern of "input + gold block = output"
            if (inputStack.method_31574(outputStack.method_7909())) {
                if (MidasGoldSword.Type.isOf(inputStack, ROYAL)) {
                    inputStack.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(640, true));
                } else if (MidasGoldSword.Type.isOf(inputStack, GILDED)) {
                    inputStack.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(320));
                } else {
                    inputStack.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(16));
                }
                return List.of(
                    EntryIngredients.ofIngredient(this.template),
                    EntryIngredients.of(inputStack),
                    EntryIngredients.ofIngredient(this.addition)
                );
            }
            // Handles transformation from regular midas to gilded midas
            if (MidasGoldSword.Type.isOf(inputStack, REGULAR) && MidasGoldSword.Type.isOf(outputStack, GILDED)) {
                inputStack.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(319));
                return List.of(
                    EntryIngredients.ofIngredient(this.template),
                    EntryIngredients.of(inputStack),
                    EntryIngredients.ofIngredient(this.addition)
                );
            }
            // Transformation of gilded to royal midas
            if (MidasGoldSword.Type.isOf(inputStack, GILDED) && MidasGoldSword.Type.isOf(outputStack, ROYAL)) {
                inputStack.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(640));
                return List.of(
                    EntryIngredients.ofIngredient(this.template),
                    EntryIngredients.of(inputStack),
                    EntryIngredients.ofIngredient(this.addition)
                );
            }
        }

        return super.getInputEntries();
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        if (this.base != null && this.addition != null && this.outputStack != null) {
            // Handle folding recipes, which usually follow the pattern of "input + gold block = output"
            var inputStack = Arrays.stream(this.base.method_8105()).findFirst().orElseGet(() -> new class_1799(class_1802.field_8162)).method_7972();
            if (outputStack.method_7909().equals(inputStack.method_7909())) {

                if (MidasGoldSword.Type.isOf(outputStack, ROYAL)) {
                    outputStack.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(641, true));
                } else if (MidasGoldSword.Type.isOf(outputStack, GILDED)) {
                    outputStack.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(321));
                } else {
                    outputStack.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(17));
                }

                return List.of(
                    EntryIngredients.of(outputStack)
                );
            }
            // Royal Midas Handler
            if (MidasGoldSword.Type.isOf(outputStack, ROYAL)) {
                var outputWithNbt = outputStack.method_7972();
                outputWithNbt.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(640));
                return List.of(
                    EntryIngredients.of(outputWithNbt)
                );

            }
            // Gilded Midas Handler
            if (MidasGoldSword.Type.isOf(outputStack, GILDED)) {
                var outputWithNbt = outputStack.method_7972();
                outputWithNbt.method_57379(GOLD_FOLDED, GoldFoldedComponent.of(320));
                return List.of(
                    EntryIngredients.of(outputWithNbt)
                );
            }
        }
        return super.getOutputEntries();
    }
}

