package com.mythicmetals.compat;

import com.mythicmetals.component.GoldFoldedComponent;
import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.item.tools.MidasGoldSword;
import com.mythicmetals.recipe.MidasFoldingRecipe;
import dev.emi.emi.api.recipe.*;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import org.jetbrains.annotations.Nullable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;

import static com.mythicmetals.item.tools.MidasGoldSword.Type.*;

public class MidasFoldingEMIRecipe implements EmiRecipe {

    class_1856 template;
    class_1856 base;
    class_1856 addition;
    List<EmiIngredient> inputs;
    EmiStack output;
    class_2960 id;

    public MidasFoldingEMIRecipe(MidasFoldingRecipe recipe) {
        this.template = recipe.template();
        this.base = recipe.base();
        this.addition = recipe.addition();
        var outputStack = recipe.result();

        if (this.base != null && this.addition != null && outputStack != null) {
            var inputStack = Arrays.stream(this.base.method_8105()).findFirst().orElse(class_1799.field_8037).method_7972();
            // Handle folding recipes, which usually follow the pattern of "input + gold block = output"
            if (outputStack.method_31574(inputStack.method_7909())) {
                if (MidasGoldSword.Type.isOf(inputStack, ROYAL)) {
                    inputStack.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(640, true));
                } else if (MidasGoldSword.Type.isOf(inputStack, GILDED)) {
                    inputStack.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(320));
                } else {
                    inputStack.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(16));
                }
                inputs = List.of(
                    EmiIngredient.of(this.template),
                    EmiStack.of(inputStack),
                    EmiIngredient.of(this.addition)
                );
            }
            // Handles transformation from regular midas to gilded midas
            else if (MidasGoldSword.Type.isOf(inputStack, REGULAR) && MidasGoldSword.Type.isOf(outputStack, GILDED)) {
                inputStack.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(319));
                inputs = List.of(
                    EmiIngredient.of(this.template),
                    EmiStack.of(inputStack),
                    EmiIngredient.of(this.addition)
                );
            }
            // Transformation of gilded to royal midas
            else if (MidasGoldSword.Type.isOf(inputStack, GILDED) && MidasGoldSword.Type.isOf(outputStack, ROYAL)) {
                inputStack.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(319));
                inputs = List.of(
                    EmiIngredient.of(this.template),
                    EmiStack.of(inputStack),
                    EmiIngredient.of(this.addition)
                );
            }

            // Handle folding recipes, which usually follow the pattern of "input + gold block = output"
            if (outputStack.method_7909().equals(inputStack.method_7909())) {
                if (MidasGoldSword.Type.isOf(outputStack, ROYAL)) {
                    outputStack.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(641, true));
                } else if (MidasGoldSword.Type.isOf(outputStack, GILDED)) {
                    outputStack.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(321));
                } else {
                    outputStack.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(17));
                }

                output = EmiStack.of(outputStack);
            }
            // Royal Midas Handler
            else if (MidasGoldSword.Type.isOf(outputStack, ROYAL)) {
                var outputCopy = outputStack.method_7972();
                outputCopy.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(640, true));
                output = EmiStack.of(outputCopy);

            }
            // Gilded Midas Handler
            else if (MidasGoldSword.Type.isOf(outputStack, GILDED)) {
                var outputCopy = outputStack.method_7972();
                outputCopy.method_57379(MythicDataComponents.GOLD_FOLDED, GoldFoldedComponent.of(320));
                output = EmiStack.of(outputCopy);
            }
        }

    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.SMITHING;
    }

    @Override
    public @Nullable class_2960 getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return inputs;
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(output);
    }

    @Override
    public int getDisplayWidth() {
        return 112;
    }

    @Override
    public int getDisplayHeight() {
        return 18;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
        widgets.addSlot(inputs.get(0), 0, 0);
        widgets.addSlot(inputs.get(1), 18, 0);
        widgets.addSlot(inputs.get(2), 36, 0);
        widgets.addSlot(output, 94, 0).recipeContext(this);
    }
}
