package com.mythicmetals.compat;

import com.mythicmetals.item.tools.MythicTools;
import com.mythicmetals.misc.RegistryHelper;
import com.mythicmetals.recipe.MidasFoldingRecipe;
import com.mythicmetals.recipe.TidesingerCoralRecipe;
import dev.emi.emi.api.*;
import dev.emi.emi.api.stack.EmiStack;
import net.minecraft.class_3956;
import net.minecraft.class_8059;
import net.minecraft.class_8786;
import net.minecraft.recipe.*;

@EmiEntrypoint
public class MythicMetalsEMIPlugin implements EmiPlugin {

    @Override
    public void register(EmiRegistry registry) {
        for (class_8786<class_8059> recipe : registry.getRecipeManager().method_30027(class_3956.field_25388)) {
            if (recipe.comp_1933() instanceof MidasFoldingRecipe foldingRecipe) {
                registry.addRecipe(new MidasFoldingEMIRecipe(foldingRecipe));
            }
            if (recipe.comp_1933() instanceof TidesingerCoralRecipe tidesingerCoralRecipe) {
                registry.addRecipe(new TidesingerEMIRecipe(tidesingerCoralRecipe, recipe.comp_1932()));
            }
        }
        registry.removeRecipes(RegistryHelper.id("hoe/based"));
        registry.removeRecipes(RegistryHelper.id("hoe/blazed"));
        registry.removeEmiStacks(EmiStack.of(MythicTools.Frogery.FROGE));
        registry.removeEmiStacks(EmiStack.of(MythicTools.Frogery.DOGE));
    }
}
