package com.mythicmetals.compat;

import com.mythicmetals.item.tools.MythicTools;
import com.mythicmetals.recipe.MidasFoldingRecipe;
import com.mythicmetals.recipe.TidesingerCoralRecipe;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_3956;
import net.minecraft.class_6880;
import net.minecraft.class_9334;
import java.util.*;

public class MythicMetalsREIClientPlugin implements REIClientPlugin {

    @Override
    public void registerDisplays(DisplayRegistry registry) {
        registry.registerRecipeFiller(MidasFoldingRecipe.class, class_3956.field_25388, MidasFoldingDisplay::new);
        registry.registerRecipeFiller(TidesingerCoralRecipe.class, class_3956.field_25388, TidesingerSmithingDisplay::new);

        // Tipped Runite Arrow handling
        EntryIngredient arrowStack = EntryIngredient.of(EntryStacks.of(MythicTools.RUNITE_ARROW));
        ReferenceSet<class_1842> registeredPotions = new ReferenceOpenHashSet<>();
        EntryRegistry.getInstance().getEntryStacks().filter(entry -> entry.getValueType() == class_1799.class && entry.<class_1799>castValue().method_7909() == class_1802.field_8150).forEach(entry -> {
            class_1799 itemStack = (class_1799) entry.getValue();
            if (itemStack.method_57826(class_9334.field_49651)) {
                var potion = itemStack.method_57824(class_9334.field_49651).comp_2378().get();
                if (registeredPotions.add(potion.comp_349())) {
                    List<EntryIngredient> input = new ArrayList<>();
                    for (int i = 0; i < 4; i++)
                        input.add(arrowStack);
                    input.add(EntryIngredients.of(itemStack));
                    for (int i = 0; i < 4; i++)
                        input.add(arrowStack);
                    var outputStack = class_1844.method_57400(MythicTools.TIPPED_RUNITE_ARROW, potion);
                    outputStack.method_7939(8);
                    EntryIngredient output = EntryIngredients.of(outputStack);
                    registry.add(new DefaultCustomDisplay(null, input, Collections.singletonList(output)));
                }
            }
        });
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        // There are many secrets in this game...
        // ... many of which that drive peeps insane
        registry.removeEntry(EntryStacks.of(MythicTools.Frogery.FROGE));
        registry.removeEntry(EntryStacks.of(MythicTools.Frogery.DOGE));
    }
}
