package com.mythicmetals.compat;

import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.TidesingerPatternComponent;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.recipe.TidesingerCoralRecipe;
import dev.emi.emi.api.recipe.*;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import org.jetbrains.annotations.Nullable;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2960;

public class TidesingerEMIRecipe implements EmiRecipe {

    class_1856 template;
    class_1856 base;
    class_1856 addition;
    List<EmiIngredient> inputs;
    EmiStack outputs;
    class_2960 id;

    public TidesingerEMIRecipe(TidesingerCoralRecipe recipe, class_2960 id) {
        this.id = id;
        this.template = recipe.template();
        this.base = recipe.base();
        this.addition = recipe.addition();

        if (this.base != null && this.addition != null && template != null) {
            var inputStack = Arrays.stream(this.base.method_8105()).findFirst().orElse(class_1799.field_8037).method_7972();
            inputs = List.of(
                EmiIngredient.of(this.template),
                EmiStack.of(inputStack),
                EmiIngredient.of(this.addition)
            );

            var additionStack = Arrays.stream(this.addition.method_8105()).findFirst().orElse(class_1799.field_8037).method_7972();
            var outputStack = recipe.result();
            if (outputStack != null && additionStack.method_31573(MythicTags.TIDESINGER_CORAL)) {
                var outputWithComponents = outputStack.method_56701(outputStack.method_7909(), outputStack.method_7947());
                outputWithComponents.method_57379(MythicDataComponents.TIDESINGER, TidesingerPatternComponent.fromStack(additionStack));
                outputs = EmiStack.of(outputWithComponents);
            }
        }


    }

    @Override
    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.SMITHING;
    }

    @Override
    public @Nullable class_2960 getId() {
        return this.id;
    }

    @Override
    public List<EmiIngredient> getInputs() {
        return inputs;
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(outputs);
    }

    @Override
    public int getDisplayWidth() {
        return 112;
    }

    @Override
    public int getDisplayHeight() {
        return 18;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
        widgets.addSlot(inputs.get(0), 0, 0);
        widgets.addSlot(inputs.get(1), 18, 0);
        widgets.addSlot(inputs.get(2), 36, 0);
        widgets.addSlot(outputs, 94, 0).recipeContext(this);
    }
}
