package com.mythicmetals.compat;

import com.mythicmetals.component.MythicDataComponents;
import com.mythicmetals.component.TidesingerPatternComponent;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.recipe.TidesingerCoralRecipe;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.displays.DefaultSmithingDisplay;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_8786;
import java.util.Arrays;
import java.util.List;

public class TidesingerSmithingDisplay extends DefaultSmithingDisplay {
    class_1856 template;
    class_1856 base;
    class_1856 addition;
    class_1799 outputStack;

    public TidesingerSmithingDisplay(class_8786<TidesingerCoralRecipe> recipe) {
        super(
            recipe.comp_1933(),
            recipe.comp_1932(),
            List.of(EntryIngredients.ofIngredient(recipe.comp_1933().template()),
                EntryIngredients.ofIngredient(recipe.comp_1933().base()),
                EntryIngredients.ofIngredient(recipe.comp_1933().addition())
            )
        );

        this.template = recipe.comp_1933().template();
        this.base = recipe.comp_1933().base();
        this.addition = recipe.comp_1933().addition();
        this.outputStack = recipe.comp_1933().result();

    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        if (this.base != null && this.addition != null && outputStack != null) {
            return List.of(EntryIngredients.ofIngredient(this.template), EntryIngredients.ofIngredient(this.base), EntryIngredients.ofIngredient(this.addition));
        }
        return super.getInputEntries();
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        if (this.base != null && this.addition != null && this.outputStack != null) {
            var additionStack = Arrays.stream(this.addition.method_8105()).findFirst().orElse(class_1799.field_8037).method_7972();
            if (additionStack.method_31573(MythicTags.TIDESINGER_CORAL)) {
                outputStack.method_57379(MythicDataComponents.TIDESINGER, TidesingerPatternComponent.fromItem(additionStack.method_7909()));
                return List.of(EntryIngredients.of(outputStack));
            }
        }
        return super.getOutputEntries();
    }
}

