package com.mythicmetals.component;

import com.mythicmetals.misc.UsefulSingletonForColorUtil;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3532;
import net.minecraft.class_9299;

public record DrillComponent(int fuel) implements class_9299 {
    public static final Endec<DrillComponent> ENDEC = StructEndecBuilder.of(
        Endec.INT.fieldOf("fuel", DrillComponent::fuel),
        DrillComponent::new
    );
    public static final DrillComponent DEFAULT = new DrillComponent(0);

    /**
     * One fuel lets you break one block with all the Drill perks
     */
    public static final int MAX_FUEL = 4000;
    /**
     * Each piece of Morkite will fuel the drill by this constant worth of units
     */
    public static final int FUEL_CONSTANT = 20;


    public DrillComponent reduce(int fuel) {
        return new DrillComponent(class_3532.method_15340(fuel - 1, 0, MAX_FUEL));
    }

    public DrillComponent increase(int fuel) {
        return new DrillComponent(class_3532.method_15340(fuel + 1, 0, MAX_FUEL));
    }

    public boolean hasFuel() {
        return this.fuel > 0;
    }

    @Override
    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {

        // Activation Status
        if (this.hasFuel()) {
            tooltip.accept(class_2561.method_43471("tooltip.mythril_drill.activated").method_27692(class_124.field_1075));
        }
        if (this.fuel == 0) {
            tooltip.accept(class_2561.method_43471("tooltip.mythril_drill.refuel").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        }
        // Fuel Gauge
        tooltip.accept(class_2561.method_43469("tooltip.mythril_drill.fuel", this.fuel, MAX_FUEL)
            .method_27696(class_2583.field_24360.method_36139(UsefulSingletonForColorUtil.getSlightlyDarkerOwoBlueToRedGradient(this.fuel, MAX_FUEL))));

    }
}
