package com.mythicmetals.component;

import com.mythicmetals.item.tools.MidasGoldSword;
import com.mythicmetals.misc.UsefulSingletonForColorUtil;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_9299;

public record GoldFoldedComponent(int goldFolded, boolean isRoyal, boolean showTooltip) implements class_9299 {

    public static final StructEndec<GoldFoldedComponent> ENDEC = StructEndecBuilder.of(
        StructEndec.INT.fieldOf("gold_folded", GoldFoldedComponent::goldFolded),
        StructEndec.BOOLEAN.fieldOf("is_royal", GoldFoldedComponent::isRoyal),
        StructEndec.BOOLEAN.fieldOf("show_tooltip", GoldFoldedComponent::showTooltip),
        GoldFoldedComponent::new
    );

    public static GoldFoldedComponent of(int folds, boolean isRoyal) {
        return new GoldFoldedComponent(folds, isRoyal, true);
    }

    public static GoldFoldedComponent of(int folds) {
        return new GoldFoldedComponent(folds, false, true);
    }

    @Override
    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        if (!showTooltip) return;

        int level = MidasGoldSword.calculateSwordLevel(this.goldFolded);

        if (level > 20) {
            level = 20 + level / 6;
        }

        if (this.goldFolded < 704 && this.isRoyal()) {
            level = 11;
        }

        // Spout fun facts and lore while leveling up the sword
        tooltip.accept(class_2561.method_43471("tooltip.midas_gold.level." + level).method_27692(class_124.field_1065));
        if (this.goldFolded == 0) {
            return;
        }

        // Remove the cap from tooltip when maxed
        if (this.goldFolded >= 1280) {
            if (this.goldFolded == 10000) {
                // e.g. **⭐10000 FOLDS - MAXED⭐**
                tooltip.accept(class_2561.method_43469("tooltip.midas_gold.maxed", this.goldFolded).method_27695(class_124.field_1065, class_124.field_1067));
            } else {
                // e.g. Folds: 2500
                tooltip.accept(class_2561.method_43469("tooltip.midas_gold.fold_counter", this.goldFolded).method_27692(class_124.field_1065));
            }
            if (this.isRoyal) {
                tooltip.accept(class_2561.method_43471("tooltip.midas_gold.is_royal").method_10862(UsefulSingletonForColorUtil.MetalColors.GOLD_STYLE));
            }
            return;
        }

        // Handle the cap format
        if (this.isRoyal()) {
            // e.g. 63/1280
            tooltip.accept(class_2561.method_43470(this.goldFolded + " / " + 1280).method_27692(class_124.field_1065));
        } else if (goldFolded() >= 321) {
            // e.g. 63/640
            tooltip.accept(class_2561.method_43470(this.goldFolded + " / " + 640).method_27692(class_124.field_1065));
        } else {
            // e.g. 63/128
            tooltip.accept(class_2561.method_43470(this.goldFolded + " / " + (64 + level * 64)).method_27692(class_124.field_1065));
        }

        // If this isn't done here, the ability text won't show up due to return guard
        if (this.isRoyal) {
            tooltip.accept(class_2561.method_43471("tooltip.midas_gold.is_royal").method_10862(UsefulSingletonForColorUtil.MetalColors.GOLD_STYLE));
        }
    }
}
