package com.mythicmetals.component;

import I;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.misc.RegistryHelper;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_9701;

/**
 * A data carrier which holds and tracks the Prometheum Auto Repair ability.
 * Only applies to items within the {@link MythicTags#AUTO_REPAIR} tag.
 * <br>
 * If the Item is an {@link net.minecraft.class_1738} it gains bonus armor, and/or armor toughness.
 * Otherwise, if the Item has {@link net.minecraft.class_9334#field_49636} it will gain bonus damage.
 * <br>
 * Append this component on your {@link net.minecraft.class_1792.class_1793} to use it.
 *
 * @see com.mythicmetals.mixin.ItemMixin
 */
public record PrometheumComponent(int durabilityRepaired) {
    public static final int OVERGROWN_THRESHOLD = 1200;
    public static final StructEndec<PrometheumComponent> ENDEC = StructEndecBuilder.of(
        StructEndec.INT.fieldOf("durability_repaired", PrometheumComponent::durabilityRepaired),
        PrometheumComponent::new
    );
    public static final class_2960 ARMOR_BONUS_ID = RegistryHelper.id("prometheum_armor_bonus");
    public static final class_2960 TOUGHNESS_BONUS_ID = RegistryHelper.id("prometheum_toughness_bonus");
    public static final class_2960 DAMAGE_BONUS_ID = RegistryHelper.id("prometheum_damage_bonus");
    public static final PrometheumComponent DEFAULT = new PrometheumComponent(0);

    /**
     * Applies auto repair onto the item in question
     *
     * @param stack ItemStack to repair
     * @param world World where the ItemStack exists
     */
    public static void tickAutoRepair(class_1799 stack, class_1937 world) {
        if (!stack.method_7986()) return; // Don't handle auto repair if item is fully repaired
        if (world.method_8608()) return; // Desyncs if done on client
        if (!stack.method_57826(MythicDataComponents.PROMETHEUM)) return;
        var random = world.method_8409();

        var component = stack.method_57824(MythicDataComponents.PROMETHEUM);
        assert component != null;

        var dmg = stack.method_7919();
        var rng = random.method_43048(200);

        if (rng != 177) return; // Roll for repair, ignore if roll fails. Number is arbitrary

        // Overgrown Items repair faster
        int damageToRepair = isOvergrown(stack) ? 2 : 1;

        // Extra repair speed if bound
        if (class_1890.method_60142(stack, class_9701.field_51656)) {
            damageToRepair += 1;
        }

        int newDamage = class_3532.method_15340(dmg - damageToRepair, 0, Integer.MAX_VALUE);
        stack.method_7974(newDamage);
        stack.method_57379(MythicDataComponents.PROMETHEUM, component.increase(damageToRepair));
    }

    public PrometheumComponent increase(int durabilityRepaired) {
        return new PrometheumComponent(this.durabilityRepaired + durabilityRepaired);
    }

    public boolean isOvergrown() {
        return this.durabilityRepaired > OVERGROWN_THRESHOLD;
    }

    public static boolean isOvergrown(class_1799 stack) {
        return stack.method_57825(MythicDataComponents.PROMETHEUM, DEFAULT).durabilityRepaired > OVERGROWN_THRESHOLD;
    }

    public static class_1322 createOvergrownModifier(class_1799 stack, int base) {
        return createOvergrownModifier(stack, base, class_1304.field_6173);
    }

    public static class_1322 createOvergrownModifier(class_1799 stack, int base, class_1304 slot) {
        var id = switch (slot.method_5925()) {
            case field_6177 -> DAMAGE_BONUS_ID;
            case field_6178, field_48825 -> ARMOR_BONUS_ID;
        };
        var component = stack.method_57825(MythicDataComponents.PROMETHEUM, PrometheumComponent.DEFAULT);
        int bonus = base;
        bonus += component.durabilityRepaired() > (OVERGROWN_THRESHOLD * 2) ? 2 : 1;
        return new class_1322(
            id,
            bonus,
            class_1322.class_1323.field_6328);
    }

    public static class_1322 createOvergrownToughnessModifier(class_1799 stack, int base) {
        var component = stack.method_57825(MythicDataComponents.PROMETHEUM, PrometheumComponent.DEFAULT);
        int bonus = base;
        bonus += component.durabilityRepaired() > (OVERGROWN_THRESHOLD * 2) ? 2 : 1;
        bonus += class_1890.method_60142(stack, class_9701.field_51656) ? 1 : 0;
        return new class_1322(
            TOUGHNESS_BONUS_ID,
            bonus,
            class_1322.class_1323.field_6328);
    }
}
