package com.mythicmetals.component;

import com.mythicmetals.misc.UsefulSingletonForColorUtil;
import io.wispforest.endec.Endec;
import io.wispforest.endec.impl.StructEndecBuilder;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_9299;
import net.minecraft.item.*;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

/**
 * Component used for the different armor variants of the Tidesinger Armor
 *
 * @param pattern used for tooltip handling
 * @see TidesingerPatternComponent#TIDESINGER_VARIANTS
 */
public record TidesingerPatternComponent(String pattern) implements class_9299 {
    /**
     * Map which holds a string used for translation keys, depending on the coral item used
     */
    public static Map<class_1792, String> TIDESINGER_VARIANTS = class_156.method_654(new HashMap<>(), map -> {
        map.put(class_1802.field_8616, "brain");
        map.put(class_1802.field_8538, "bubble");
        map.put(class_1802.field_8546, "fire");
        map.put(class_1802.field_8847, "tube");
        map.put(class_1802.field_8723, "horn");
    });
    public static final Endec<TidesingerPatternComponent> ENDEC = StructEndecBuilder.of(
        Endec.STRING.fieldOf("pattern", TidesingerPatternComponent::pattern),
        TidesingerPatternComponent::new
    );

    public static TidesingerPatternComponent fromStack(class_1799 stack) {
        return fromItem(stack.method_7909());
    }

    public static TidesingerPatternComponent fromItem(class_1792 item) {
        return new TidesingerPatternComponent(TIDESINGER_VARIANTS.getOrDefault(item, ""));
    }

    public static TidesingerPatternComponent empty() {
        return new TidesingerPatternComponent("");
    }

    @Override
    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type) {
        class_2583 style = switch (this.pattern) {
            case "brain" -> UsefulSingletonForColorUtil.MetalColors.BRAIN.style();
            case "bubble" -> UsefulSingletonForColorUtil.MetalColors.BUBBLE.style();
            case "fire" -> UsefulSingletonForColorUtil.MetalColors.FIRE.style();
            case "horn" -> UsefulSingletonForColorUtil.MetalColors.HORN.style();
            case "tube" -> UsefulSingletonForColorUtil.MetalColors.TUBE.style();
            default -> class_2583.field_24360;
        };

        // Do not append tooltip if there isn't a proper coral on it
        if (style.method_10967()) {
            return;
        }
        tooltip.accept(class_2561.method_43471("tooltip.tidesinger.coral." + this.pattern).method_10862(style));
    }
}
