package com.mythicmetals.data;

import io.wispforest.owo.util.ReflectionUtils;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.registry.*;
import java.util.concurrent.CompletableFuture;

import static com.mythicmetals.data.MythicOreBiomeTags.*;

public class MythicBiomeTagProvider extends FabricTagProvider<class_1959> {

    /**
     * Constructs a new {@link FabricTagProvider} with the default computed path.
     *
     * <p>Common implementations of this class are provided.
     *
     * @param output           the {@link FabricDataOutput} instance
     * @param registriesFuture the backing registry for the tag type
     */
    public MythicBiomeTagProvider(FabricDataOutput output, class_5321<? extends class_2378<class_1959>> registryKey, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registryKey, registriesFuture);
    }

    @SuppressWarnings("UnstableApiUsage")
    @Override
    protected void method_10514(class_7225.class_7874 wrapperLookup) {
        ReflectionUtils.iterateAccessibleStaticFields(MythicOreBiomeTags.class, class_6862.class, (value, name, field) -> {
            var tag = (class_6862<class_1959>) value;
            if (tag.equals(END_STARRITE_BIOMES)) {
                method_10512(tag)
                    .forceAddTag(ConventionalBiomeTags.IS_END);
            } else if (tag.equals(STORMYX_BIOMES) || tag.equals(NETHER_BANGLUM_BIOMES) || tag.equals(PALLADIUM_BIOMES)) {
                method_10512(tag)
                    .forceAddTag(ConventionalBiomeTags.IS_NETHER);
            } else if (tag.equals(OSMIUM_BIOMES)) {
                method_10512(tag)
                    .forceAddTag(ConventionalBiomeTags.IS_MOUNTAIN)
                    .forceAddTag(ConventionalBiomeTags.IS_HILL);
            } else if (tag.equals(PROMETHEUM_BIOMES)) {
                method_10512(tag)
                    .forceAddTag(ConventionalBiomeTags.IS_JUNGLE)
                    .method_46835(class_1972.field_29218);
            } else if (tag.equals(AQUARIUM_BIOMES)) {
                method_10512(tag)
                    .forceAddTag(ConventionalBiomeTags.IS_AQUATIC);
            } else if (!tag.equals(MYTHIC_ORE_BIOMES)) {
                method_10512(tag)
                    .forceAddTag(MYTHIC_ORE_BIOMES);
            }
        });
        method_10512(MYTHIC_ORE_BIOMES)
            .forceAddTag(ConventionalBiomeTags.IS_OVERWORLD);
    }
}
