package com.mythicmetals.data;

import com.mythicmetals.block.BlockSet;
import com.mythicmetals.block.MythicBlocks;
import io.wispforest.owo.util.ReflectionUtils;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricTagProvider;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class MythicBlockTagProvider extends FabricTagProvider.BlockTagProvider {

    public MythicBlockTagProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @SuppressWarnings("UnstableApiUsage")
    @Override
    protected void method_10514(class_7225.class_7874 arg) {
        ReflectionUtils.iterateAccessibleStaticFields(MythicBlocks.class, BlockSet.class, (blockSet, name, field) -> {
            var modOreTag = MythicMetalsData.createModBlockTag("ores");
            var commonOreTag = ConventionalBlockTags.ORES;

            if (blockSet.getOre() != null) {
                var string = "ores/" + name;
                var modTag = MythicMetalsData.createModBlockTag(string);
                var commonTag = MythicMetalsData.createCommonBlockTag(string);
                var tagBuilder = method_10512(modTag).add(blockSet.getOre());
                method_10512(commonTag).method_26792(modTag);

                if (!blockSet.getOreVariants().isEmpty()) {
                    blockSet.getOreVariants().forEach(tagBuilder::add);
                }
                method_10512(modOreTag).method_26792(modTag);
                method_10512(commonOreTag).method_26792(modTag);
            }

            if (blockSet.getOreStorageBlock() != null) {
                var string = "storage_blocks/raw_" + name;
                var modTag = MythicMetalsData.createModBlockTag(string);
                var commonTag = MythicMetalsData.createCommonBlockTag(string);
                method_10512(modTag).add(blockSet.getOreStorageBlock());
                method_10512(commonTag).method_26792(modTag);
            }

            if (blockSet.getStorageBlock() != null) {
                var string = "storage_blocks/" + name;
                var modTag = MythicMetalsData.createModBlockTag(string);
                var commonTag = MythicMetalsData.createCommonBlockTag(string);
                method_10512(modTag).add(blockSet.getStorageBlock());
                method_10512(commonTag).method_26792(modTag);
            }
        });
    }
}
