package com.mythicmetals.data;

import com.mythicmetals.misc.RegistryHelper;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator.Pack;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7877;
import net.minecraft.class_7924;

public class MythicMetalsData implements DataGeneratorEntrypoint {

    @Override
    public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
        var data = fabricDataGenerator.createPack();
        data.addProvider(MythicBlockTagProvider::new);
        data.addProvider(MythicItemTagProvider::new);
        data.addProvider(MythicMetalsDynamicRegistryProvider::new);
        data.addProvider(MythicRecipeProvider::new);
        data.addProvider((output, registriesFuture) -> {
            return new MythicBiomeTagProvider(output, class_7924.field_41236, registriesFuture);
        });
    }

    @Override
    public void buildRegistry(class_7877 registryBuilder) {
        registryBuilder.method_46777(class_7924.field_41239, MythicOreFeatureProvider::initConfiguredFeatures);
        registryBuilder.method_46777(class_7924.field_41245, MythicOreFeatureProvider::initPlacedFeatures);
    }

    public static class_6862<class_1792> createCommonItemTag(String path) {
        return class_6862.method_40092(class_7924.field_41197, class_2960.method_60655("c", path));
    }

    public static class_6862<class_1792> createModItemTag(String path) {
        return class_6862.method_40092(class_7924.field_41197, RegistryHelper.id(path));
    }

    public static class_6862<class_2248> createCommonBlockTag(String path) {
        return class_6862.method_40092(class_7924.field_41254, class_2960.method_60655("c", path));
    }

    public static class_6862<class_2248> createModBlockTag(String path) {
        return class_6862.method_40092(class_7924.field_41254, RegistryHelper.id(path));
    }
}
