package com.mythicmetals.data;

import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.config.MythicOreConfigs;
import net.minecraft.class_2975;
import net.minecraft.class_6796;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;

import static com.mythicmetals.data.MythicOreFeatures.*;
import static com.mythicmetals.data.MythicOreRules.*;

public class MythicOreFeatureProvider {
    public static void initConfiguredFeatures(class_7891<class_2975<?, ?>> registerable) {
        // above 0
        OreFeatureHelper.configuredFeature(registerable, ORE_AQUARIUM, STONE_RULE, MythicBlocks.AQUARIUM.getOre(), MythicOreConfigs.AQUARIUM);
        OreFeatureHelper.configuredFeature(registerable, ORE_BANGLUM, STONE_RULE, MythicBlocks.BANGLUM.getOre(), MythicOreConfigs.BANGLUM);
        OreFeatureHelper.configuredFeature(registerable, ORE_KYBER, STONE_RULE, MythicBlocks.KYBER.getOre(), MythicOreConfigs.KYBER);
        OreFeatureHelper.configuredFeature(registerable, ORE_MANGANESE, STONE_RULE, MythicBlocks.MANGANESE.getOre(), MythicOreConfigs.MANGANESE);
        OreFeatureHelper.configuredFeature(registerable, ORE_OSMIUM, STONE_RULE, MythicBlocks.OSMIUM.getOre(), MythicOreConfigs.OSMIUM);
        OreFeatureHelper.configuredFeature(registerable, ORE_PLATINUM, STONE_RULE, MythicBlocks.PLATINUM.getOre(), MythicOreConfigs.PLATINUM);
        OreFeatureHelper.configuredFeature(registerable, ORE_QUADRILLUM, STONE_RULE, MythicBlocks.QUADRILLUM.getOre(), MythicOreConfigs.QUADRILLUM);
        OreFeatureHelper.configuredFeature(registerable, ORE_RUNITE, RUNITE_TARGETS, MythicOreConfigs.RUNITE);
        OreFeatureHelper.configuredFeature(registerable, ORE_SILVER, STONE_RULE, MythicBlocks.SILVER.getOre(), MythicOreConfigs.SILVER);
        OreFeatureHelper.configuredFeature(registerable, ORE_TIN, STONE_RULE, MythicBlocks.TIN.getOre(), MythicOreConfigs.TIN);
        // usually below 0
        OreFeatureHelper.configuredFeature(registerable, ORE_ADAMANTITE, ADAMANTITE_TARGETS, MythicOreConfigs.ADAMANTITE);
        OreFeatureHelper.configuredFeature(registerable, ORE_CALCITE_KYBER, CALCITE_RULE, MythicBlocks.KYBER.getOreVariant("calcite"), MythicOreConfigs.CALCITE_KYBER);
        OreFeatureHelper.configuredFeature(registerable, ORE_CARMOT, CARMOT_TARGETS, MythicOreConfigs.CARMOT);
        OreFeatureHelper.configuredFeature(registerable, ORE_DEEPSLATE_RUNITE, RUNITE_TARGETS, MythicOreConfigs.DEEPSLATE_RUNITE);
        OreFeatureHelper.configuredFeature(registerable, ORE_MYTHRIL, MYTHRIL_TARGETS, MythicOreConfigs.MYTHRIL);
        OreFeatureHelper.configuredFeature(registerable, ORE_MORKITE, MORKITE_TARGETS, MythicOreConfigs.MORKITE);
        OreFeatureHelper.configuredFeature(registerable, ORE_ORICHALCUM, ORICHALCUM_TARGETS, MythicOreConfigs.ORICHALCUM);
        OreFeatureHelper.configuredFeature(registerable, ORE_PROMETHEUM, PROMETHEUM_TARGETS, MythicOreConfigs.PROMETHEUM);
        OreFeatureHelper.configuredFeature(registerable, ORE_STARRITE, STARRITE_TARGETS, MythicOreConfigs.STARRITE);
        OreFeatureHelper.configuredFeature(registerable, ORE_UNOBTAINIUM, UNOBTAINIUM_TARGETS, MythicOreConfigs.UNOBTAINIUM);
        // nether
        OreFeatureHelper.configuredFeature(registerable, ORE_NETHER_BANGLUM, NETHERRACK_RULE, MythicBlocks.BANGLUM.getOreVariant("nether"), MythicOreConfigs.NETHER_BANGLUM);
        OreFeatureHelper.configuredFeature(registerable, ORE_MIDAS_GOLD, NETHERRACK_RULE, MythicBlocks.MIDAS_GOLD.getOre(), MythicOreConfigs.MIDAS_GOLD);
        OreFeatureHelper.configuredFeature(registerable, ORE_PALLADIUM, NETHERRACK_RULE, MythicBlocks.PALLADIUM.getOre(), MythicOreConfigs.PALLADIUM);
        OreFeatureHelper.configuredFeature(registerable, ORE_STORMYX, STORMYX_TARGETS, MythicOreConfigs.STORMYX);
        // end ore
        OreFeatureHelper.configuredFeature(registerable, ORE_END_STARRITE, END_STONE_RULE, MythicBlocks.STARRITE.getOreVariant("end_stone"), MythicOreConfigs.END_STARRITE);
    }

    public static void initPlacedFeatures(class_7891<class_6796> registerable) {
        var featureLookup = registerable.method_46799(class_7924.field_41239);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_AQUARIUM).method_40237(), AQUARIUM, MythicOreConfigs.AQUARIUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_BANGLUM).method_40237(), BANGLUM, MythicOreConfigs.BANGLUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_KYBER).method_40237(), KYBER, MythicOreConfigs.KYBER);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_MANGANESE).method_40237(), MANGANESE, MythicOreConfigs.MANGANESE);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_OSMIUM).method_40237(), OSMIUM, MythicOreConfigs.OSMIUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_PLATINUM).method_40237(), PLATINUM, MythicOreConfigs.PLATINUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_QUADRILLUM).method_40237(), QUADRILLUM, MythicOreConfigs.QUADRILLUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_RUNITE).method_40237(), RUNITE, MythicOreConfigs.RUNITE);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_SILVER).method_40237(), SILVER, MythicOreConfigs.SILVER);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_TIN).method_40237(), TIN, MythicOreConfigs.TIN);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_ADAMANTITE).method_40237(), ADAMANTITE, MythicOreConfigs.ADAMANTITE);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_CALCITE_KYBER).method_40237(), CALCITE_KYBER, MythicOreConfigs.CALCITE_KYBER);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_CARMOT).method_40237(), CARMOT, MythicOreConfigs.CARMOT);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_DEEPSLATE_RUNITE).method_40237(), DEEPSLATE_RUNITE, MythicOreConfigs.DEEPSLATE_RUNITE);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_MYTHRIL).method_40237(), MYTHRIL, MythicOreConfigs.MYTHRIL);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_MORKITE).method_40237(), MORKITE, MythicOreConfigs.MORKITE);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_ORICHALCUM).method_40237(), ORICHALCUM, MythicOreConfigs.ORICHALCUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_PROMETHEUM).method_40237(), PROMETHEUM, MythicOreConfigs.PROMETHEUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_STARRITE).method_40237(), STARRITE, MythicOreConfigs.STARRITE);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_UNOBTAINIUM).method_40237(), UNOBTAINIUM, MythicOreConfigs.UNOBTAINIUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_NETHER_BANGLUM).method_40237(), NETHER_BANGLUM, MythicOreConfigs.NETHER_BANGLUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_MIDAS_GOLD).method_40237(), MIDAS_GOLD, MythicOreConfigs.MIDAS_GOLD);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_PALLADIUM).method_40237(), PALLADIUM, MythicOreConfigs.PALLADIUM);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_STORMYX).method_40237(), STORMYX, MythicOreConfigs.STORMYX);
        OreFeatureHelper.create(registerable, featureLookup.method_46747(ORE_END_STARRITE).method_40237(), END_STARRITE, MythicOreConfigs.END_STARRITE);

    }
}
