package com.mythicmetals.data;

import com.mythicmetals.misc.RegistryHelper;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_2893;
import net.minecraft.class_2975;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_7924;

import static com.mythicmetals.MythicMetals.CONFIG;

public class MythicOreFeatures {
    public static final class_5321<class_2975<?, ?>> ORE_AQUARIUM = RegistryHelper.configuredFeatureKey("ore_aquarium");
    public static final class_5321<class_2975<?, ?>> ORE_BANGLUM = RegistryHelper.configuredFeatureKey("ore_banglum");
    public static final class_5321<class_2975<?, ?>> ORE_KYBER = RegistryHelper.configuredFeatureKey("ore_kyber");
    public static final class_5321<class_2975<?, ?>> ORE_MANGANESE = RegistryHelper.configuredFeatureKey("ore_manganese");
    public static final class_5321<class_2975<?, ?>> ORE_OSMIUM = RegistryHelper.configuredFeatureKey("ore_osmium");
    public static final class_5321<class_2975<?, ?>> ORE_PLATINUM = RegistryHelper.configuredFeatureKey("ore_platinum");
    public static final class_5321<class_2975<?, ?>> ORE_QUADRILLUM = RegistryHelper.configuredFeatureKey("ore_quadrillum");
    public static final class_5321<class_2975<?, ?>> ORE_RUNITE = RegistryHelper.configuredFeatureKey("ore_runite");
    public static final class_5321<class_2975<?, ?>> ORE_SILVER = RegistryHelper.configuredFeatureKey("ore_silver");
    public static final class_5321<class_2975<?, ?>> ORE_TIN = RegistryHelper.configuredFeatureKey("ore_tin");

    public static final class_5321<class_2975<?, ?>> ORE_ADAMANTITE = RegistryHelper.configuredFeatureKey("ore_adamantite");
    public static final class_5321<class_2975<?, ?>> ORE_CALCITE_KYBER = RegistryHelper.configuredFeatureKey("ore_calcite_kyber");
    public static final class_5321<class_2975<?, ?>> ORE_CARMOT = RegistryHelper.configuredFeatureKey("ore_carmot");
    public static final class_5321<class_2975<?, ?>> ORE_DEEPSLATE_RUNITE = RegistryHelper.configuredFeatureKey("ore_deepslate_runite");
    public static final class_5321<class_2975<?, ?>> ORE_MORKITE = RegistryHelper.configuredFeatureKey("ore_morkite");
    public static final class_5321<class_2975<?, ?>> ORE_MYTHRIL = RegistryHelper.configuredFeatureKey("ore_mythril");
    public static final class_5321<class_2975<?, ?>> ORE_ORICHALCUM = RegistryHelper.configuredFeatureKey("ore_orichalcum");
    public static final class_5321<class_2975<?, ?>> ORE_PROMETHEUM = RegistryHelper.configuredFeatureKey("ore_prometheum");
    public static final class_5321<class_2975<?, ?>> ORE_STARRITE = RegistryHelper.configuredFeatureKey("ore_starrite");
    public static final class_5321<class_2975<?, ?>> ORE_UNOBTAINIUM = RegistryHelper.configuredFeatureKey("ore_unobtainium");

    public static class_5321<class_2975<?, ?>> ORE_NETHER_BANGLUM = RegistryHelper.configuredFeatureKey("ore_nether_banglum");
    public static class_5321<class_2975<?, ?>> ORE_MIDAS_GOLD = RegistryHelper.configuredFeatureKey("ore_midas_gold");
    public static class_5321<class_2975<?, ?>> ORE_PALLADIUM = RegistryHelper.configuredFeatureKey("ore_palladium");
    public static class_5321<class_2975<?, ?>> ORE_STORMYX = RegistryHelper.configuredFeatureKey("ore_stormyx");
    public static class_5321<class_2975<?, ?>> ORE_END_STARRITE = RegistryHelper.configuredFeatureKey("ore_end_starrite");

    // RegistryKeys for features
    public static final class_5321<class_6796> ADAMANTITE = class_5321.method_29179(class_7924.field_41245, ORE_ADAMANTITE.method_29177());
    public static final class_5321<class_6796> AQUARIUM = class_5321.method_29179(class_7924.field_41245, ORE_AQUARIUM.method_29177());
    public static final class_5321<class_6796> BANGLUM = class_5321.method_29179(class_7924.field_41245, ORE_BANGLUM.method_29177());
    public static final class_5321<class_6796> NETHER_BANGLUM = class_5321.method_29179(class_7924.field_41245, ORE_NETHER_BANGLUM.method_29177());
    public static final class_5321<class_6796> CARMOT = class_5321.method_29179(class_7924.field_41245, ORE_CARMOT.method_29177());
    public static final class_5321<class_6796> CALCITE_KYBER = class_5321.method_29179(class_7924.field_41245, ORE_CALCITE_KYBER.method_29177());
    public static final class_5321<class_6796> END_STARRITE = class_5321.method_29179(class_7924.field_41245, ORE_END_STARRITE.method_29177());
    public static final class_5321<class_6796> KYBER = class_5321.method_29179(class_7924.field_41245, ORE_KYBER.method_29177());
    public static final class_5321<class_6796> MANGANESE = class_5321.method_29179(class_7924.field_41245, ORE_MANGANESE.method_29177());
    public static final class_5321<class_6796> MIDAS_GOLD = class_5321.method_29179(class_7924.field_41245, ORE_MIDAS_GOLD.method_29177());
    public static final class_5321<class_6796> MORKITE = class_5321.method_29179(class_7924.field_41245, ORE_MORKITE.method_29177());
    public static final class_5321<class_6796> MYTHRIL = class_5321.method_29179(class_7924.field_41245, ORE_MYTHRIL.method_29177());
    public static final class_5321<class_6796> ORICHALCUM = class_5321.method_29179(class_7924.field_41245, ORE_ORICHALCUM.method_29177());
    public static final class_5321<class_6796> OSMIUM = class_5321.method_29179(class_7924.field_41245, ORE_OSMIUM.method_29177());
    public static final class_5321<class_6796> PALLADIUM = class_5321.method_29179(class_7924.field_41245, ORE_PALLADIUM.method_29177());
    public static final class_5321<class_6796> PLATINUM = class_5321.method_29179(class_7924.field_41245, ORE_PLATINUM.method_29177());
    public static final class_5321<class_6796> PROMETHEUM = class_5321.method_29179(class_7924.field_41245, ORE_PROMETHEUM.method_29177());
    public static final class_5321<class_6796> QUADRILLUM = class_5321.method_29179(class_7924.field_41245, ORE_QUADRILLUM.method_29177());
    public static final class_5321<class_6796> DEEPSLATE_RUNITE = class_5321.method_29179(class_7924.field_41245, ORE_DEEPSLATE_RUNITE.method_29177());
    public static final class_5321<class_6796> RUNITE = class_5321.method_29179(class_7924.field_41245, ORE_RUNITE.method_29177());
    public static final class_5321<class_6796> SILVER = class_5321.method_29179(class_7924.field_41245, ORE_SILVER.method_29177());
    public static final class_5321<class_6796> STARRITE = class_5321.method_29179(class_7924.field_41245, ORE_STARRITE.method_29177());
    public static final class_5321<class_6796> STORMYX = class_5321.method_29179(class_7924.field_41245, ORE_STORMYX.method_29177());
    public static final class_5321<class_6796> TIN = class_5321.method_29179(class_7924.field_41245, ORE_TIN.method_29177());
    public static final class_5321<class_6796> UNOBTAINIUM = class_5321.method_29179(class_7924.field_41245, ORE_UNOBTAINIUM.method_29177());

    public static void init() {

        //Overworld Ores
        if (CONFIG.adamantite()) {
            OreFeatureHelper.ore(ADAMANTITE, MythicOreBiomeTags.ADAMANTITE_BIOMES);
        }
        if (CONFIG.banglum()) {
            OreFeatureHelper.ore(BANGLUM, MythicOreBiomeTags.BANGLUM_BIOMES);
        }
        if (CONFIG.carmot()) {
            OreFeatureHelper.ore(CARMOT, MythicOreBiomeTags.CARMOT_BIOMES);
        }
        if (CONFIG.kyber()) {
            OreFeatureHelper.ore(KYBER, MythicOreBiomeTags.KYBER_BIOMES);
            OreFeatureHelper.ore(CALCITE_KYBER, MythicOreBiomeTags.CALCITE_KYBER_BIOMES);
        }
        if (CONFIG.mythril()) {
            OreFeatureHelper.ore(MYTHRIL, MythicOreBiomeTags.MYTHRIL_BIOMES);
        }
        if (CONFIG.orichalcum()) {
            OreFeatureHelper.ore(ORICHALCUM, MythicOreBiomeTags.ORICHALCUM_BIOMES);
        }
        if (CONFIG.manganese()) {
            OreFeatureHelper.ore(MANGANESE, MythicOreBiomeTags.MANGANESE_BIOMES);
        }
        if (CONFIG.platinum()) {
            OreFeatureHelper.ore(PLATINUM, MythicOreBiomeTags.PLATINUM_BIOMES);
        }
        if (CONFIG.quadrillum()) {
            OreFeatureHelper.ore(QUADRILLUM, MythicOreBiomeTags.QUADRILLUM_BIOMES);
        }
        if (CONFIG.runite()) {
            OreFeatureHelper.ore(RUNITE, MythicOreBiomeTags.RUNITE_BIOMES);
            OreFeatureHelper.ore(DEEPSLATE_RUNITE, MythicOreBiomeTags.DEEPSLATE_RUNITE_BIOMES);
        }
        if (CONFIG.silver()) {
            OreFeatureHelper.ore(SILVER, MythicOreBiomeTags.SILVER_BIOMES);
        }
        if (CONFIG.starrite()) {
            OreFeatureHelper.ore(STARRITE, MythicOreBiomeTags.STARRITE_BIOMES);
        }
        if (CONFIG.endStarrite()) {
            OreFeatureHelper.ore(END_STARRITE, MythicOreBiomeTags.END_STARRITE_BIOMES);
        }
        if (CONFIG.tin()) {
            OreFeatureHelper.ore(TIN, MythicOreBiomeTags.TIN_BIOMES);
        }
        if (CONFIG.unobtainium()) {
            OreFeatureHelper.ore(UNOBTAINIUM, MythicOreBiomeTags.UNOBTAINIUM_BIOMES);
        }
        if (CONFIG.morkite()) {
            OreFeatureHelper.ore(MORKITE, MythicOreBiomeTags.MORKITE_BIOMES);
        }

        //Nether Ores
        if (CONFIG.banglum()) {
            OreFeatureHelper.ore(NETHER_BANGLUM, MythicOreBiomeTags.NETHER_BANGLUM_BIOMES);
        }
        if (CONFIG.midasGold()) {
            OreFeatureHelper.ore(MIDAS_GOLD, MythicOreBiomeTags.MIDAS_GOLD_BIOMES);
        }
        if (CONFIG.stormyx()) {
            OreFeatureHelper.ore(STORMYX, MythicOreBiomeTags.STORMYX_BIOMES);
        }
        if (CONFIG.palladium()) {
            OreFeatureHelper.ore(PALLADIUM, MythicOreBiomeTags.PALLADIUM_BIOMES);
        }

        // Add Aquarium to Aquatic Biomes
        if (CONFIG.aquarium()) {
            BiomeModifications.addFeature(BiomeSelectors.tag(MythicOreBiomeTags.AQUARIUM_BIOMES), class_2893.class_2895.field_13176, AQUARIUM);
        }
        // Add Prometheum to hot biomes
        if (CONFIG.prometheum()) {
            BiomeModifications.addFeature(BiomeSelectors.tag(MythicOreBiomeTags.PROMETHEUM_BIOMES), class_2893.class_2895.field_13176, PROMETHEUM);
        }
        // Add Osmium to mountainous biomes
        if (CONFIG.osmium()) {
            BiomeModifications.addFeature(BiomeSelectors.tag(MythicOreBiomeTags.OSMIUM_BIOMES), class_2893.class_2895.field_13176, OSMIUM);
        }
    }

}
