package com.mythicmetals.data;

import com.google.common.collect.ImmutableList;
import com.mythicmetals.block.MythicBlocks;
import net.minecraft.class_2246;
import net.minecraft.class_3124;
import net.minecraft.class_3481;
import net.minecraft.class_3798;
import net.minecraft.class_3819;
import net.minecraft.class_3825;
import net.minecraft.structure.rule.*;

public class MythicOreRules {
    // Defines new RuleTest(s), which checks what blocks an ore can spawn in
    public static final class_3825 BLACKSTONE_RULE = new class_3819(class_2246.field_23869);
    public static final class_3825 CALCITE_RULE = new class_3819(class_2246.field_27114);
    public static final class_3825 NETHERRACK_RULE = new class_3819(class_2246.field_10515);
    public static final class_3825 DEEPSLATE_RULE = new class_3798(class_3481.field_28993);
    public static final class_3825 END_STONE_RULE = new class_3819(class_2246.field_10471);
    public static final class_3825 SMOOTH_BASALT_RULE = new class_3819(class_2246.field_29032);
    public static final class_3825 STONE_RULE = new class_3798(class_3481.field_28992);
    public static final class_3825 TUFF_RULE = new class_3819(class_2246.field_27165);


    // Defines a list of targets, which can check for multiple blocks and dynamically replace them when generating ore
    public static final ImmutableList<class_3124.class_5876> ADAMANTITE_TARGETS = ImmutableList.of(
        class_3124.method_33994(STONE_RULE, MythicBlocks.ADAMANTITE.getOre().method_9564()),
        class_3124.method_33994(DEEPSLATE_RULE, MythicBlocks.ADAMANTITE.getOreVariant("deepslate").method_9564()));
    public static final ImmutableList<class_3124.class_5876> CARMOT_TARGETS = ImmutableList.of(
        class_3124.method_33994(STONE_RULE, MythicBlocks.CARMOT.getOre().method_9564()),
        class_3124.method_33994(DEEPSLATE_RULE, MythicBlocks.CARMOT.getOreVariant("deepslate").method_9564()));
    public static final ImmutableList<class_3124.class_5876> MYTHRIL_TARGETS = ImmutableList.of(
        class_3124.method_33994(STONE_RULE, MythicBlocks.MYTHRIL.getOre().method_9564()),
        class_3124.method_33994(DEEPSLATE_RULE, MythicBlocks.MYTHRIL.getOreVariant("deepslate").method_9564()));
    public static final ImmutableList<class_3124.class_5876> MORKITE_TARGETS = ImmutableList.of(
        class_3124.method_33994(STONE_RULE, MythicBlocks.MORKITE.getOre().method_9564()),
        class_3124.method_33994(DEEPSLATE_RULE, MythicBlocks.MORKITE.getOreVariant("deepslate").method_9564()));
    public static final ImmutableList<class_3124.class_5876> ORICHALCUM_TARGETS = ImmutableList.of(
        class_3124.method_33994(STONE_RULE, MythicBlocks.ORICHALCUM.getOre().method_9564()),
        class_3124.method_33994(TUFF_RULE, MythicBlocks.ORICHALCUM.getOreVariant("tuff").method_9564()),
        class_3124.method_33994(SMOOTH_BASALT_RULE, MythicBlocks.ORICHALCUM.getOreVariant("smooth_basalt").method_9564()),
        class_3124.method_33994(DEEPSLATE_RULE, MythicBlocks.ORICHALCUM.getOreVariant("deepslate").method_9564()));
    public static final ImmutableList<class_3124.class_5876> PROMETHEUM_TARGETS = ImmutableList.of(
        class_3124.method_33994(STONE_RULE, MythicBlocks.PROMETHEUM.getOre().method_9564()),
        class_3124.method_33994(DEEPSLATE_RULE, MythicBlocks.PROMETHEUM.getOreVariant("deepslate").method_9564()));
    public static final ImmutableList<class_3124.class_5876> RUNITE_TARGETS = ImmutableList.of(
        class_3124.method_33994(STONE_RULE, MythicBlocks.RUNITE.getOre().method_9564()),
        class_3124.method_33994(DEEPSLATE_RULE, MythicBlocks.RUNITE.getOreVariant("deepslate").method_9564()));
    public static final ImmutableList<class_3124.class_5876> STARRITE_TARGETS = ImmutableList.of(
        class_3124.method_33994(STONE_RULE, MythicBlocks.STARRITE.getOre().method_9564()),
        class_3124.method_33994(CALCITE_RULE, MythicBlocks.STARRITE.getOreVariant("calcite").method_9564()));
    public static final ImmutableList<class_3124.class_5876> STORMYX_TARGETS = ImmutableList.of(
        class_3124.method_33994(NETHERRACK_RULE, MythicBlocks.STORMYX.getOre().method_9564()),
        class_3124.method_33994(BLACKSTONE_RULE, MythicBlocks.STORMYX.getOreVariant("blackstone").method_9564()));
    public static final ImmutableList<class_3124.class_5876> UNOBTAINIUM_TARGETS = ImmutableList.of(
        class_3124.method_33994(STONE_RULE, MythicBlocks.UNOBTAINIUM.getOre().method_9564()),
        class_3124.method_33994(DEEPSLATE_RULE, MythicBlocks.UNOBTAINIUM.getOreVariant("deepslate").method_9564()));

}
