package com.mythicmetals.data;

import ;
import F;
import com.mythicmetals.armor.ArmorSet;
import com.mythicmetals.armor.MythicArmor;
import com.mythicmetals.block.BlockSet;
import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.conditions.DustLoadedCondition;
import com.mythicmetals.conditions.NuggetsLoadedCondition;
import com.mythicmetals.item.ItemSet;
import com.mythicmetals.item.MythicItems;
import com.mythicmetals.misc.RegistryHelper;
import io.wispforest.owo.util.ReflectionUtils;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2248;
import net.minecraft.class_2454;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_7924;
import net.minecraft.class_8790;
import java.util.*;
import java.util.concurrent.CompletableFuture;

public class MythicRecipeProvider extends FabricRecipeProvider {

    public MythicRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @SuppressWarnings("UnstableApiUsage")
    @Override
    public void method_10419(class_8790 exporter) {
        var itemSets = new HashMap<String, ItemSet>();
        var blockSets = new HashMap<String, BlockSet>();

        var dustExporter = withConditions(exporter, new DustLoadedCondition());
        var nuggetExporter = withConditions(exporter, new NuggetsLoadedCondition());

        // Handle items first, as they store whether the items need blasting to be smelted
        ReflectionUtils.iterateAccessibleStaticFields(MythicItems.class, ItemSet.class, (itemSet, name, field) -> {
            itemSets.put(name, itemSet);
        });

        ReflectionUtils.iterateAccessibleStaticFields(MythicBlocks.class, BlockSet.class, (blockSet, name, field) -> {
            blockSets.put(name, blockSet);
        });

        // Smelting armor into nuggets
        ReflectionUtils.iterateAccessibleStaticFields(MythicArmor.class, ArmorSet.class, (armorSet, name, field) -> {
            if (itemSets.containsKey(name) && itemSets.get(name).getNugget() != null) {
                var itemSet = itemSets.get(name);
                boolean requiresBlasting = itemSet.requiresBlasting();
                var nugget = itemSet.getNugget();
                class_1935[] armorItems = new class_1935[0];
                armorItems = armorSet.getArmorItems().toArray(armorItems);

                if (!requiresBlasting) {
                    class_2454.method_17802(class_1856.method_8091(armorItems), class_7800.field_40642, nugget, 0.1f, 200)
                        .method_10469("has_material", method_10420(class_6862.method_40092(class_7924.field_41197, RegistryHelper.id("nuggets/" + name))))
                        .method_17972(nuggetExporter, RegistryHelper.id("smelting/" + name.toLowerCase(Locale.ROOT) + "_nugget_from_armor"));
                }
                class_2454.method_10473(class_1856.method_8091(armorItems), class_7800.field_40642, nugget, 0.1f, 100)
                    .method_10469("has_material", method_10420(class_6862.method_40092(class_7924.field_41197, RegistryHelper.id("nuggets/" + name))))
                    .method_17972(nuggetExporter, RegistryHelper.id("blasting/" + name.toLowerCase(Locale.ROOT) + "_nugget_from_armor"));
            }
        });

        // Smelting ore blocks into ingots
        itemSets.forEach((name, itemSet) -> {
            // Smelting Ore Blocks into ingots
            if (blockSets.containsKey(name) && blockSets.get(name).getOre() != null) {
                var blockSet = blockSets.get(name);
                var oreList = new ArrayList<>(blockSet.getOreVariants());
                oreList.add(blockSet.getOre());
                var items = oreList.stream().map(class_2248::method_8389).toList().toArray(new class_1792[0]);

                var ingot = itemSet.getIngot();
                var xp = itemSet.getXp();
                boolean requiresBlasting = itemSet.requiresBlasting();
                var critera = method_10423(class_2073.class_2074.method_8973().method_8977(items).method_8976());

                if (!requiresBlasting) {
                    class_2454.method_17802(class_1856.method_8091(items), class_7800.field_40642, ingot, xp, 200)
                        .method_10469("has_material", critera)
                        .method_17972(exporter, RegistryHelper.id("smelting/" + name.toLowerCase(Locale.ROOT) + "_from_ores"));
                }
                class_2454.method_10473(class_1856.method_8091(items), class_7800.field_40642, ingot, xp, 100)
                    .method_10469("has_material", critera)
                    .method_17972(exporter, RegistryHelper.id("blasting/" + name.toLowerCase(Locale.ROOT) + "_from_ores"));
            }

            // Smelting Raw Ores into ingots
            if (itemSet.getRawOre() != null) {
                if (!itemSet.requiresBlasting()) {
                    class_2454.method_17802(class_1856.method_8091(itemSet.getRawOre()), class_7800.field_40642, itemSet.getIngot(), itemSet.getXp(), 200)
                        .method_10469("has_material", method_10426(itemSet.getRawOre()))
                        .method_17972(exporter, RegistryHelper.id("smelting/" + name.toLowerCase(Locale.ROOT) + "_from_raw_ore"));
                }
                class_2454.method_10473(class_1856.method_8091(itemSet.getRawOre()), class_7800.field_40642, itemSet.getIngot(), itemSet.getXp(), 100)
                    .method_10469("has_material", method_10426(itemSet.getRawOre()))
                    .method_17972(exporter, RegistryHelper.id("blasting/" + name.toLowerCase(Locale.ROOT) + "_from_raw_ore"));
            }
            // Smelting dusts into ingots
            if (itemSet.getDust() != null) {
                if (!itemSet.requiresBlasting()) {
                    class_2454.method_17802(class_1856.method_8091(itemSet.getDust()), class_7800.field_40642, itemSet.getIngot(), itemSet.getXp(), 200)
                        .method_10469("has_material", method_10420(class_6862.method_40092(class_7924.field_41197, RegistryHelper.id("dusts/" + name))))
                        .method_17972(dustExporter, RegistryHelper.id("smelting/" + name.toLowerCase(Locale.ROOT) + "_from_dust"));
                }
                class_2454.method_10473(class_1856.method_8091(itemSet.getDust()), class_7800.field_40642, itemSet.getIngot(), itemSet.getXp(), 100)
                    .method_10469("has_material", method_10420(class_6862.method_40092(class_7924.field_41197, RegistryHelper.id("dusts/" + name))))
                    .method_17972(dustExporter, RegistryHelper.id("blasting/" + name.toLowerCase(Locale.ROOT) + "_from_dust"));
            }
        });


    }
}
