package com.mythicmetals.data;

import Z;
import com.google.common.collect.ImmutableList;
import com.mythicmetals.config.OreConfig;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.BiomeSelectors;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2893;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3124;
import net.minecraft.class_3825;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5843;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6803;
import net.minecraft.class_6817;
import net.minecraft.class_6862;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7924;
import net.minecraft.registry.*;
import net.minecraft.world.gen.feature.*;
import net.minecraft.world.gen.placementmodifier.*;
import java.util.List;

/**
 * A helper class for adding creating and adding ore features to the world.
 */
public class OreFeatureHelper {

    public static void ore(class_5321<class_6796> ore, class_6862<class_1959> tag) {
        BiomeModifications.addFeature(BiomeSelectors.tag(tag), class_2893.class_2895.field_13176, ore);
    }

    public static void configuredFeature(class_7891<class_2975<?, ?>> registerable, class_5321<class_2975<?, ?>> featureKey, class_3825 rule, class_2248 oreBlock, OreConfig config) {
        class_6803.method_39708(registerable, featureKey, class_3031.field_13517, configuredConfig(rule, oreBlock, config));
    }

    public static void configuredFeature(class_7891<class_2975<?, ?>> registerable, class_5321<class_2975<?, ?>> featureKey, ImmutableList<class_3124.class_5876> target, OreConfig config) {
        class_6803.method_39708(registerable, featureKey, class_3031.field_13517, configuredConfig(target, config));
    }

    public static class_3124 configuredConfig(class_3825 test, class_2248 block, OreConfig config) {
        return new class_3124(test, block.method_9564(), config.veinSize, config.discardChance);
    }

    public static class_3124 configuredConfig(ImmutableList<class_3124.class_5876> target, OreConfig config) {
        return new class_3124(target, config.veinSize, config.discardChance);
    }

    public static void create(class_7891<class_6796> registerable, class_5321<class_2975<?, ?>> configuredFeatureKey, class_5321<class_6796> placedFeatureKey, OreConfig config) {
        var b = config.offset && config.trapezoid; // Check if both offset and trapezoid is being used at the same time.
        if (b) {
            throw new IllegalArgumentException(registerable.toString() + " cannot be offset and trapezoid at the same time.");
        } else if (config.offset) {
            placeAboveBottom(registerable, configuredFeatureKey, placedFeatureKey, config);
        } else if (config.trapezoid) {
            placeTrapezoid(registerable, configuredFeatureKey, placedFeatureKey, config);
        } else {
            placeUniform(registerable, configuredFeatureKey, placedFeatureKey, config);
        }
    }

    public static void placeUniform(class_7891<class_6796> registerable, class_5321<class_2975<?, ?>> configuredFeatureKey, class_5321<class_6796> placedFeatureKey, OreConfig config) {
        var featureLookup = registerable.method_46799(class_7924.field_41239);
        class_6817.method_39737(registerable, placedFeatureKey, featureLookup.method_46747(configuredFeatureKey), modifiersWithCount(config.perChunk, class_6795.method_39634(class_5843.method_33841(config.bottom), class_5843.method_33841(config.top))));
    }

    public static void placeAboveBottom(class_7891<class_6796> registerable, class_5321<class_2975<?, ?>> configuredFeatureKey, class_5321<class_6796> placedFeatureKey, OreConfig config) {
        var featureLookup = registerable.method_46799(class_7924.field_41239);
        class_6817.method_39737(registerable, placedFeatureKey, featureLookup.method_46747(configuredFeatureKey), modifiersWithCount(config.perChunk, class_6795.method_39634(class_5843.method_33846(config.bottom), class_5843.method_33841(config.top))));
    }

    public static void placeTrapezoid(class_7891<class_6796> registerable, class_5321<class_2975<?, ?>> configuredFeatureKey, class_5321<class_6796> placedFeatureKey, OreConfig config) {
        var featureLookup = registerable.method_46799(class_7924.field_41239);
        class_6817.method_39737(registerable, placedFeatureKey, featureLookup.method_46747(configuredFeatureKey), modifiersWithCount(config.perChunk, class_6795.method_39637(class_5843.method_33841(config.bottom), class_5843.method_33841(config.top))));
    }

    //From Mojanks OrePlacedFeatures
    private static List<class_6797> modifiers(class_6797 countModifier, class_6797 heightModifier) {
        return List.of(countModifier, class_5450.method_39639(), heightModifier, class_6792.method_39614());
    }

    private static List<class_6797> modifiersWithCount(int count, class_6797 heightModifier) {
        return modifiers(class_6793.method_39623(count), heightModifier);
    }

}
