package com.mythicmetals.entity;

import com.mojang.authlib.GameProfile;
import com.mythicmetals.MythicMetals;
import com.mythicmetals.block.MythicBlocks;
import com.mythicmetals.data.MythicTags;
import com.mythicmetals.misc.*;
import com.mythicmetals.registry.RegisterSounds;
import eu.pb4.common.protection.api.CommonProtection;
import io.wispforest.endec.impl.KeyedEndec;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import org.jetbrains.annotations.Nullable;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class BanglumNukeEntity extends BanglumTntEntity {
    private static final int DEFAULT_FUSE = 200;
    private static final KeyedEndec<class_2248> CORE_BLOCK_KEY = MinecraftEndecs.ofRegistry(class_7923.field_41175).keyed("core_block", MythicBlocks.BANGLUM_NUKE_CORE);

    private class_2248 coreBlock = MythicBlocks.BANGLUM_NUKE_CORE;

    public BanglumNukeEntity(class_1299<? extends BanglumNukeEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public BanglumNukeEntity(class_1937 world, double x, double y, double z, @Nullable class_1309 igniter, class_2248 coreBlock) {
        this(MythicEntities.BANGLUM_NUKE_ENTITY_TYPE, world);
        this.method_5814(x, y, z);
        double d = world.field_9229.method_43058() * (float) (Math.PI * 2);
        this.method_18800(-Math.sin(d) * 0.01, 0.2F, -Math.cos(d) * 0.01);
        this.setFuse(DEFAULT_FUSE);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
        this.causingEntity = igniter;
        this.coreBlock = coreBlock;
    }

    @Override
    protected void method_5749(class_2487 nbt) {
        super.method_5749(nbt);

        this.coreBlock = nbt.get(CORE_BLOCK_KEY);
    }

    @Override
    protected void method_5652(class_2487 nbt) {
        super.method_5652(nbt);

        nbt.put(CORE_BLOCK_KEY, coreBlock);
    }

    @Override
    public double getSmokeParticleHeight() {
        return 2.5;
    }

    @Override
    protected void explode() {
        int radius = MythicMetals.CONFIG.banglumNukeCoreRadius();
        int baseDamage = 1;

        // Decides what blocks are ignored by the nuke
        Predicate<class_2680> statePredicate;

        if (coreBlock == MythicBlocks.CARMOT_NUKE_CORE) {
            // Carmot core - Do not destroy ores
            statePredicate = state -> !state.method_26164(MythicTags.CARMOT_NUKE_IGNORED);
        } else if (coreBlock == MythicBlocks.SPONGE_NUKE_CORE) {
            statePredicate = state -> !state.method_26227().method_15769();
        } else {
            statePredicate = ignored -> true;
        }

        // Quadrillum core - Double damage, half range
        if (coreBlock == MythicBlocks.QUADRILLUM_NUKE_CORE) {
            radius = (radius * 2) / 3;
            baseDamage = 2;
        }

        class_3222 playerCause = causingEntity instanceof class_3222 player ? player : null;
        GameProfile playerCauseProfile = playerCause == null ? CommonProtection.UNKNOWN : playerCause.method_7334();
        EpicExplosion.explode((class_3218) method_37908(), (int) this.method_23317(), (int) this.method_23318(), (int) this.method_23321(), radius, statePredicate, this, playerCause);
        class_1927 explosion = new class_1927(this.method_37908(), playerCause, (int) this.method_23317(), (int) this.method_23318(), (int) this.method_23321(), radius, false, class_1927.class_4179.field_40879);

        int soundRadius = radius * 3;

        // FIXME - Find a better way to play the sound to far-away players. Maybe use PositionedSoundInstance and the sound manager?
        for (class_1657 player : method_37908().method_18456()) {
            if (player.method_5858(this) > soundRadius * soundRadius) continue;

            player.method_37908().method_45445(this, this.method_24515(), RegisterSounds.BANGLUM_NUKE_EXPLOSION, class_3419.field_15245, 5.0F, (1.0F + (this.method_37908().field_9229.method_43057() - this.method_37908().field_9229.method_43057()) * 0.2F) * 0.7F);
        }

        // Handle damaging entities near the nuke explosion
        for (var entity : method_37908().method_8335(this, class_238.method_30048(method_19538(), radius * 2, radius * 2, radius * 2))) {
            if (entity.method_5659(explosion)) continue;
            if (!CommonProtection.canDamageEntity(method_37908(), entity, playerCauseProfile, playerCause)) continue;

            double distanceModifier = baseDamage - entity.method_5739(this) / (double) radius;
            if (distanceModifier >= 0) {
                double x = entity.method_23317() - this.method_23317();
                double y = (entity instanceof BanglumTntEntity ? entity.method_23318() : entity.method_23320()) - this.method_23318();
                double z = entity.method_23321() - this.method_23321();
                double dist = Math.sqrt(x * x + y * y + z * z);
                if (dist != 0.0) {
                    x /= dist;
                    y /= dist;
                    z /= dist;
                    var banglumNukeSource = new BanglumNukeSource(
                        method_37908().method_30349().method_30530(class_7924.field_42534).method_40264(MythicDamageTypes.BANGLUM_NUKE).orElseThrow(),
                        this,
                        this.getCausingEntity());
                    entity.method_5643(banglumNukeSource, class_3532.method_15357((distanceModifier * distanceModifier + distanceModifier) * 7.0 * radius + 1.0));

                    double knockback = distanceModifier * 5;
                    if (entity instanceof class_1309 living) {
                        knockback = distanceModifier * (5.0 - living.method_45325(class_5134.field_51580));
                    }

                    entity.method_5762(x * knockback, y * knockback, z * knockback);
                }
            }
        }
    }
}
