package com.mythicmetals.entity;

import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.Component;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;

/**
 * Component used to prevent entities from constantly receiving the {@link com.mythicmetals.effects.CombustingStatusEffect}
 */
public class CombustionCooldown implements Component, AutoSyncedComponent {
    private int cooldown;

    public CombustionCooldown(class_1309 entity) {
        cooldown = 0;
    }

    @Override
    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        cooldown = tag.method_10550("cooldown");
    }

    @Override
    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10569("cooldown", cooldown);
    }

    public void setCooldown(int ticks) {
        cooldown = ticks;
    }

    public boolean isCombustible() {
        return !(cooldown > 0);
    }

    public void tickCooldown() {
        if (cooldown > 0) {
            cooldown = class_3532.method_15340(cooldown - 1, 0, Integer.MAX_VALUE);
        }
    }
}
