package com.mythicmetals.entity;

import com.mythicmetals.item.tools.MythicTools;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1937;
import net.minecraft.class_2398;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_9334;
import net.minecraft.class_9381;
import net.minecraft.entity.*;
import net.minecraft.entity.data.*;
import org.jetbrains.annotations.Nullable;

// [VanillaCopy]
public class RuniteArrowEntity extends class_1665 {
    private static final class_2940<Integer> COLOR = class_2945.method_12791(RuniteArrowEntity.class, class_2943.field_13327);
    public static final class_1799 RUNITE_ARROW_STACK = new class_1799(MythicTools.RUNITE_ARROW);

    public RuniteArrowEntity(class_1299<RuniteArrowEntity> type, class_1937 world) {
        super(type, world);
        this.initColor();
    }

    public RuniteArrowEntity(class_1309 shooter, class_1937 world, @Nullable class_1799 shotFrom) {
        super(MythicEntities.RUNITE_ARROW_ENTITY_TYPE, shooter, world, RUNITE_ARROW_STACK, shotFrom);
        this.initColor();
    }

    public RuniteArrowEntity(class_1937 world, double x, double y, double z, class_1799 stack, @Nullable class_1799 shotFrom) {
        super(MythicEntities.RUNITE_ARROW_ENTITY_TYPE, x, y, z, world, stack, shotFrom);
    }

    public RuniteArrowEntity(class_1937 world, class_1309 owner, class_1799 stack, @Nullable class_1799 shotFrom) {
        super(MythicEntities.RUNITE_ARROW_ENTITY_TYPE, owner, world, stack, shotFrom);
        this.initColor();
    }

    private class_1844 getPotionContents() {
        return this.method_54759().method_57825(class_9334.field_49651, class_1844.field_49274);
    }

    protected void initColor() {
        class_1844 potionContentsComponent = this.getPotionContents();
        this.field_6011.method_12778(COLOR, potionContentsComponent.equals(class_1844.field_49274) ? -1 : potionContentsComponent.method_8064());
    }

    @Override
    protected class_1799 method_57314() {
        return RUNITE_ARROW_STACK;
    }

    @Override
    protected void method_7450(class_1309 target) {
        super.method_7450(target);
        class_1297 entity = this.method_37225();
        class_1844 potionContentsComponent = this.getPotionContents();
        if (potionContentsComponent.comp_2378().isPresent()) {
            for (var statusEffectInstance : potionContentsComponent.comp_2378().get().comp_349().method_8049()) {
                target.method_37222(
                    new class_1293(
                        statusEffectInstance.method_5579(),
                        Math.max(statusEffectInstance.method_48558(i -> i / 8), 1),
                        statusEffectInstance.method_5578(),
                        statusEffectInstance.method_5591(),
                        statusEffectInstance.method_5581()
                    ),
                    entity
                );
            }
        }

        for (class_1293 statusEffectInstance : potionContentsComponent.comp_2380()) {
            target.method_37222(statusEffectInstance, entity);
        }
    }

    public int getColor() {
        return this.field_6011.method_12789(COLOR);
    }

    @Override
    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(COLOR, -1);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            if (this.field_7588) {
                if (this.field_7576 % 5 == 0) {
                    this.spawnParticles(1);
                }
            } else {
                this.spawnParticles(2);
            }
        } else if (this.field_7588 && this.field_7576 != 0 && !this.getPotionContents().equals(class_1844.field_49274) && this.field_7576 >= 600) {
            this.method_37908().method_8421(this, (byte) 0);
            this.method_57313(RUNITE_ARROW_STACK);
        }
    }

    private void spawnParticles(int amount) {
        int i = this.getColor();
        if (i != -1 && amount > 0) {
            for (int j = 0; j < amount; ++j) {
                this.method_37908()
                    .method_8406(
                        class_9381.method_58256(class_2398.field_11226, i), this.method_23322(0.5), this.method_23319(), this.method_23325(0.5), 0.0, 0.0, 0.0
                    );
            }
        }
    }
}
